$(function(){
	var available = "Available";
	var not_available = "Not Available";
	var timedelay = 1000;
	var processing = "Processing...";
	
	$('#keywords').on('keyup',function(){
		delay(function(){
			$('#message').html(processing);
			$.post(window.location+'index.php/main/check',{
				keywords : $('input[name="keywords"]').val()
			}, function (data, textstatus){
				var data = jQuery.parseJSON(data);
				
				$('#message').html(data.message);
				$('#result').empty();
				var availability;
				$.each(data.domains, function(tld, avail){
					if(avail){
						$('#result').append("<div class='result-row'>"+
											"<div class='keywords'><a target='_blank' href='http://"+data.keywords+"."+tld+"'>"+data.keywords+"."+tld+"</a></div>"+
											"<div class='buttons'>"+
												"<span class='save' save='"+data.keywords+"."+tld+"'>Save</span>"+
												"<div class='availability "+avail+"'>Available</div>"+
											"</div>"+
											"</div>");
					}else{
						$('#result').append("<div class='result-row'>"+
											"<div class='keywords'><a target='_blank' href='http://"+data.keywords+"."+tld+"'>"+data.keywords+"."+tld+"</a></div>"+
											"<div class='buttons'>"+
												"<div class='availability "+avail+"'>Not Available</div>"+
												"<a class='whois' target='_blank' href='http://who.godaddy.com/WhoIs.aspx?domain="+data.keywords+"."+tld+"'>Whois</a>"+
											"</div>"+
											"</div>");
					}
				});
			});
		},timedelay);
	});
	
	$('#result').on('click','.save', function(){
		$.post(window.location+'index.php/main/add_history',{
				domain : $(this).attr('save')
		}, function (data, textstatus){
			$('#history').prepend('<div class="domain" >'+data+'</div>');
		});
	});
	
	$('#clear_history').click(function(){
		$('#history').empty();
		
		$.post(window.location+'index.php/main/clear_history');
		
		return false;
	});
	
	var delay = (function(){
  		var timer = 0;
  		return function(callback, ms){
    		clearTimeout (timer);
    		timer = setTimeout(callback, ms);
  		};
	})();
});