/* 
 * Name: Date-JS
 * Version: 1.0.0alpha-2013-12-09
 * Date: 2013-12-09
 * Copyright: 2013 Gregory Wild-Smith
 * Original Project: 2008 Geoffrey McGill
 * Licence: MIT
 * URL: https://github.com/abritinthebay/datejs
 */
Date.CultureStrings={name:"en-US",englishName:"English (United States)",nativeName:"English (United States)",Sunday:"Sunday",Monday:"Monday",Tuesday:"Tuesday",Wednesday:"Wednesday",Thursday:"Thursday",Friday:"Friday",Saturday:"Saturday",Sun:"Sun",Mon:"Mon",Tue:"Tue",Wed:"Wed",Thu:"Thu",Fri:"Fri",Sat:"Sat",Su:"Su",Mo:"Mo",Tu:"Tu",We:"We",Th:"Th",Fr:"Fr",Sa:"Sa",S_Sun_Initial:"S",M_Mon_Initial:"M",T_Tue_Initial:"T",W_Wed_Initial:"W",T_Thu_Initial:"T",F_Fri_Initial:"F",S_Sat_Initial:"S",January:"January",
February:"February",March:"March",April:"April",May:"May",June:"June",July:"July",August:"August",September:"September",October:"October",November:"November",December:"December",Jan_Abbr:"Jan",Feb_Abbr:"Feb",Mar_Abbr:"Mar",Apr_Abbr:"Apr",May_Abbr:"May",Jun_Abbr:"Jun",Jul_Abbr:"Jul",Aug_Abbr:"Aug",Sep_Abbr:"Sep",Oct_Abbr:"Oct",Nov_Abbr:"Nov",Dec_Abbr:"Dec",AM:"AM",PM:"PM",firstDayOfWeek:0,twoDigitYearMax:2029,mdy:"mdy","M/d/yyyy":"M/d/yyyy","dddd, MMMM dd, yyyy":"dddd, MMMM dd, yyyy","h:mm tt":"h:mm tt",
"h:mm:ss tt":"h:mm:ss tt","dddd, MMMM dd, yyyy h:mm:ss tt":"dddd, MMMM dd, yyyy h:mm:ss tt","yyyy-MM-ddTHH:mm:ss":"yyyy-MM-ddTHH:mm:ss","yyyy-MM-dd HH:mm:ssZ":"yyyy-MM-dd HH:mm:ssZ","ddd, dd MMM yyyy HH:mm:ss":"ddd, dd MMM yyyy HH:mm:ss","MMMM dd":"MMMM dd","MMMM, yyyy":"MMMM, yyyy","^jan(uary)?":"^jan(uary)?","^feb(ruary)?":"^feb(ruary)?","^mar(ch)?":"^mar(ch)?","^apr(il)?":"^apr(il)?","^may":"^may","^jun(e)?":"^jun(e)?","^jul(y)?":"^jul(y)?","^aug(ust)?":"^aug(ust)?","^sep(t(ember)?)?":"^sep(t(ember)?)?",
"^oct(ober)?":"^oct(ober)?","^nov(ember)?":"^nov(ember)?","^dec(ember)?":"^dec(ember)?","^su(n(day)?)?":"^su(n(day)?)?","^mo(n(day)?)?":"^mo(n(day)?)?","^tu(e(s(day)?)?)?":"^tu(e(s(day)?)?)?","^we(d(nesday)?)?":"^we(d(nesday)?)?","^th(u(r(s(day)?)?)?)?":"^th(u(r(s(day)?)?)?)?","^fr(i(day)?)?":"^fr(i(day)?)?","^sa(t(urday)?)?":"^sa(t(urday)?)?","^next":"^next","^last|past|prev(ious)?":"^last|past|prev(ious)?","^(\\+|aft(er)?|from|hence)":"^(\\+|aft(er)?|from|hence)","^(\\-|bef(ore)?|ago)":"^(\\-|bef(ore)?|ago)",
"^yes(terday)?":"^yes(terday)?","^t(od(ay)?)?":"^t(od(ay)?)?","^tom(orrow)?":"^tom(orrow)?","^n(ow)?":"^n(ow)?","^ms|milli(second)?s?":"^ms|milli(second)?s?","^sec(ond)?s?":"^sec(ond)?s?","^mn|min(ute)?s?":"^mn|min(ute)?s?","^h(our)?s?":"^h(our)?s?","^w(eek)?s?":"^w(eek)?s?","^m(onth)?s?":"^m(onth)?s?","^d(ay)?s?":"^d(ay)?s?","^y(ear)?s?":"^y(ear)?s?","^(a|p)":"^(a|p)","^(a\\.?m?\\.?|p\\.?m?\\.?)":"^(a\\.?m?\\.?|p\\.?m?\\.?)","^((e(s|d)t|c(s|d)t|m(s|d)t|p(s|d)t)|((gmt)?\\s*(\\+|\\-)\\s*\\d\\d\\d\\d?)|gmt|utc)":"^((e(s|d)t|c(s|d)t|m(s|d)t|p(s|d)t)|((gmt)?\\s*(\\+|\\-)\\s*\\d\\d\\d\\d?)|gmt|utc)",
"^\\s*(st|nd|rd|th)":"^\\s*(st|nd|rd|th)","^\\s*(\\:|a(?!u|p)|p)":"^\\s*(\\:|a(?!u|p)|p)",LINT:"LINT",TOT:"TOT",CHAST:"CHAST",NZST:"NZST",NFT:"NFT",SBT:"SBT",AEST:"AEST",ACST:"ACST",JST:"JST",CWST:"CWST",CT:"CT",ICT:"ICT",MMT:"MMT",BIOT:"BST",NPT:"NPT",IST:"IST",PKT:"PKT",AFT:"AFT",MSK:"MSK",IRST:"IRST",FET:"FET",EET:"EET",CET:"CET",UTC:"UTC",GMT:"GMT",CVT:"CVT",GST:"GST",BRT:"BRT",NST:"NST",AST:"AST",EST:"EST",CST:"CST",MST:"MST",PST:"PST",AKST:"AKST",MIT:"MIT",HST:"HST",SST:"SST",BIT:"BIT",CHADT:"CHADT",
NZDT:"NZDT",AEDT:"AEDT",ACDT:"ACDT",AZST:"AZST",IRDT:"IRDT",EEST:"EEST",CEST:"CEST",BST:"BST",PMDT:"PMDT",ADT:"ADT",NDT:"NDT",EDT:"EDT",CDT:"CDT",MDT:"MDT",PDT:"PDT",AKDT:"AKDT",HADT:"HADT"};
(function(){var f=Date,a=function(a){var b,f,d;if(Date.CultureStrings&&Date.CultureStrings[a])b=Date.CultureStrings[a];else if(b=a,f=a.split("_"),d=f.length,1<d&&"^"!==a.charAt(0)&&(d=f[d-1].toLowerCase(),"initial"===d||"abbr"===d))b=f[0];"^"===a.charAt(0)&&(b=RegExp(a,"i"));return b};f.l18n={__:function(c){return a(c)},updateCultureInfo:function(){var c=Date,b={name:a("name"),englishName:a("englishName"),nativeName:a("nativeName"),dayNames:[a("Sunday"),a("Monday"),a("Tuesday"),a("Wednesday"),a("Thursday"),
a("Friday"),a("Saturday")],abbreviatedDayNames:[a("Sun"),a("Mon"),a("Tue"),a("Wed"),a("Thu"),a("Fri"),a("Sat")],shortestDayNames:[a("Su"),a("Mo"),a("Tu"),a("We"),a("Th"),a("Fr"),a("Sa")],firstLetterDayNames:[a("S_Sun_Initial"),a("M_Mon_Initial"),a("T_Tues_Initial"),a("W_Wed_Initial"),a("T_Thu_Initial"),a("F_Fri_Initial"),a("S_Sat_Initial")],monthNames:[a("January"),a("February"),a("March"),a("April"),a("May"),a("June"),a("July"),a("August"),a("September"),a("October"),a("November"),a("December")],
abbreviatedMonthNames:[a("Jan_Abbr"),a("Feb_Abbr"),a("Mar_Abbr"),a("Apr_Abbr"),a("May_Abbr"),a("Jun_Abbr"),a("Jul_Abbr"),a("Aug_Abbr"),a("Sep_Abbr"),a("Oct_Abbr"),a("Nov_Abbr"),a("Dec_Abbr")],amDesignator:a("AM"),pmDesignator:a("PM"),firstDayOfWeek:a("firstDayOfWeek"),twoDigitYearMax:a("twoDigitYearMax"),dateElementOrder:a("mdy"),formatPatterns:{shortDate:a("M/d/yyyy"),longDate:a("dddd, MMMM dd, yyyy"),shortTime:a("h:mm tt"),longTime:a("h:mm:ss tt"),fullDateTime:a("dddd, MMMM dd, yyyy h:mm:ss tt"),
sortableDateTime:a("yyyy-MM-ddTHH:mm:ss"),universalSortableDateTime:a("yyyy-MM-dd HH:mm:ssZ"),rfc1123:a("ddd, dd MMM yyyy HH:mm:ss"),monthDay:a("MMMM dd"),yearMonth:a("MMMM, yyyy")},regexPatterns:{jan:a("^jan(uary)?"),feb:a("^feb(ruary)?"),mar:a("^mar(ch)?"),apr:a("^apr(il)?"),may:a("^may"),jun:a("^jun(e)?"),jul:a("^jul(y)?"),aug:a("^aug(ust)?"),sep:a("^sep(t(ember)?)?"),oct:a("^oct(ober)?"),nov:a("^nov(ember)?"),dec:a("^dec(ember)?"),sun:a("^su(n(day)?)?"),mon:a("^mo(n(day)?)?"),tue:a("^tu(e(s(day)?)?)?"),
wed:a("^we(d(nesday)?)?"),thu:a("^th(u(r(s(day)?)?)?)?"),fri:a("^fr(i(day)?)?"),sat:a("^sa(t(urday)?)?"),future:a("^next"),past:a("^last|past|prev(ious)?"),add:a("^(\\+|aft(er)?|from|hence)"),subtract:a("^(\\-|bef(ore)?|ago)"),yesterday:a("^yes(terday)?"),today:a("^t(od(ay)?)?"),tomorrow:a("^tom(orrow)?"),now:a("^n(ow)?"),millisecond:a("^ms|milli(second)?s?"),second:a("^sec(ond)?s?"),minute:a("^mn|min(ute)?s?"),hour:a("^h(our)?s?"),week:a("^w(eek)?s?"),month:a("^m(onth)?s?"),day:a("^d(ay)?s?"),year:a("^y(ear)?s?"),
shortMeridian:a("^(a|p)"),longMeridian:a("^(a\\.?m?\\.?|p\\.?m?\\.?)"),timezone:a("^((e(s|d)t|c(s|d)t|m(s|d)t|p(s|d)t)|((gmt)?\\s*(\\+|\\-)\\s*\\d\\d\\d\\d?)|gmt|utc)"),ordinalSuffix:a("^\\s*(st|nd|rd|th)"),timeContext:a("^\\s*(\\:|a(?!u|p)|p)")},timezones:[],abbreviatedTimeZoneDST:{},abbreviatedTimeZoneStandard:{}};b.abbreviatedTimeZoneDST[a("CHADT")]="+1345";b.abbreviatedTimeZoneDST[a("NZDT")]="+1300";b.abbreviatedTimeZoneDST[a("AEDT")]="+1100";b.abbreviatedTimeZoneDST[a("ACDT")]="+1030";b.abbreviatedTimeZoneDST[a("AZST")]=
"+0500";b.abbreviatedTimeZoneDST[a("IRDT")]="+0430";b.abbreviatedTimeZoneDST[a("EEST")]="+0300";b.abbreviatedTimeZoneDST[a("CEST")]="+0200";b.abbreviatedTimeZoneDST[a("BST")]="+0100";b.abbreviatedTimeZoneDST[a("PMDT")]="-0200";b.abbreviatedTimeZoneDST[a("ADT")]="-0300";b.abbreviatedTimeZoneDST[a("NDT")]="-0230";b.abbreviatedTimeZoneDST[a("EDT")]="-0400";b.abbreviatedTimeZoneDST[a("CDT")]="-0500";b.abbreviatedTimeZoneDST[a("MDT")]="-0600";b.abbreviatedTimeZoneDST[a("PDT")]="-0700";b.abbreviatedTimeZoneDST[a("AKDT")]=
"-0800";b.abbreviatedTimeZoneDST[a("HADT")]="-0900";b.abbreviatedTimeZoneStandard[a("LINT")]="+1400";b.abbreviatedTimeZoneStandard[a("TOT")]="+1300";b.abbreviatedTimeZoneStandard[a("CHAST")]="+1245";b.abbreviatedTimeZoneStandard[a("NZST")]="+1200";b.abbreviatedTimeZoneStandard[a("NFT")]="+1130";b.abbreviatedTimeZoneStandard[a("SBT")]="+1100";b.abbreviatedTimeZoneStandard[a("AEST")]="+1000";b.abbreviatedTimeZoneStandard[a("ACST")]="+0930";b.abbreviatedTimeZoneStandard[a("JST")]="+0900";b.abbreviatedTimeZoneStandard[a("CWST")]=
"+0845";b.abbreviatedTimeZoneStandard[a("CT")]="+0800";b.abbreviatedTimeZoneStandard[a("ICT")]="+0700";b.abbreviatedTimeZoneStandard[a("MMT")]="+0630";b.abbreviatedTimeZoneStandard[a("BST")]="+0600";b.abbreviatedTimeZoneStandard[a("NPT")]="+0545";b.abbreviatedTimeZoneStandard[a("IST")]="+0530";b.abbreviatedTimeZoneStandard[a("PKT")]="+0500";b.abbreviatedTimeZoneStandard[a("AFT")]="+0430";b.abbreviatedTimeZoneStandard[a("MSK")]="+0400";b.abbreviatedTimeZoneStandard[a("IRST")]="+0330";b.abbreviatedTimeZoneStandard[a("FET")]=
"+0300";b.abbreviatedTimeZoneStandard[a("EET")]="+0200";b.abbreviatedTimeZoneStandard[a("CET")]="+0100";b.abbreviatedTimeZoneStandard[a("GMT")]="+0000";b.abbreviatedTimeZoneStandard[a("UTC")]="+0000";b.abbreviatedTimeZoneStandard[a("CVT")]="-0100";b.abbreviatedTimeZoneStandard[a("GST")]="-0200";b.abbreviatedTimeZoneStandard[a("BRT")]="-0300";b.abbreviatedTimeZoneStandard[a("NST")]="-0330";b.abbreviatedTimeZoneStandard[a("AST")]="-0400";b.abbreviatedTimeZoneStandard[a("EST")]="-0500";b.abbreviatedTimeZoneStandard[a("CST")]=
"-0600";b.abbreviatedTimeZoneStandard[a("MST")]="-0700";b.abbreviatedTimeZoneStandard[a("PST")]="-0800";b.abbreviatedTimeZoneStandard[a("AKST")]="-0900";b.abbreviatedTimeZoneStandard[a("MIT")]="-0930";b.abbreviatedTimeZoneStandard[a("HST")]="-1000";b.abbreviatedTimeZoneStandard[a("SST")]="-1100";b.abbreviatedTimeZoneStandard[a("BIT")]="-1200";for(var f in b.abbreviatedTimeZoneStandard)b.abbreviatedTimeZoneStandard.hasOwnProperty(f)&&b.timezones.push({name:f,offset:b.abbreviatedTimeZoneStandard[f]});
for(f in b.abbreviatedTimeZoneDST)b.abbreviatedTimeZoneDST.hasOwnProperty(f)&&b.timezones.push({name:f,offset:b.abbreviatedTimeZoneDST[f],dst:!0});c.CultureInfo=b}};f.l18n.updateCultureInfo()})();
(function(){var f=Date,a=f.prototype,c=function(d,a){a||(a=2);return("000"+d).slice(-1*a)};a.clearTime=function(){this.setHours(0);this.setMinutes(0);this.setSeconds(0);this.setMilliseconds(0);return this};a.setTimeToNow=function(){var d=new Date;this.setHours(d.getHours());this.setMinutes(d.getMinutes());this.setSeconds(d.getSeconds());this.setMilliseconds(d.getMilliseconds());return this};f.today=function(){return(new Date).clearTime()};f.present=function(){return new Date};f.now?f._now||(f._now=
f.now):f._now=function(){return(new Date).getTime()};f.now=function(d){return d?f.present():f._now()};f.compare=function(d,a){if(isNaN(d)||isNaN(a))throw Error(d+" - "+a);if(d instanceof Date&&a instanceof Date)return d<a?-1:d>a?1:0;throw new TypeError(d+" - "+a);};f.equals=function(d,a){return 0===d.compareTo(a)};f.getDayNumberFromName=function(d){var a=Date.CultureInfo.dayNames,b=Date.CultureInfo.abbreviatedDayNames,c=Date.CultureInfo.shortestDayNames;d=d.toLowerCase();for(var h=0;h<a.length;h++)if(a[h].toLowerCase()===
d||b[h].toLowerCase()===d||c[h].toLowerCase()===d)return h;return-1};f.getMonthNumberFromName=function(d){var a=Date.CultureInfo.monthNames,b=Date.CultureInfo.abbreviatedMonthNames;d=d.toLowerCase();for(var c=0;c<a.length;c++)if(a[c].toLowerCase()===d||b[c].toLowerCase()===d)return c;return-1};f.isLeapYear=function(d){return 0===d%4&&0!==d%100||0===d%400};f.getDaysInMonth=function(d,a){!a&&f.validateMonth(d)&&(a=d,d=Date.today().getFullYear());return[31,f.isLeapYear(d)?29:28,31,30,31,30,31,31,30,
31,30,31][a]};f.getTimezoneAbbreviation=function(d,a){var b,c=a?Date.CultureInfo.abbreviatedTimeZoneDST:Date.CultureInfo.abbreviatedTimeZoneStandard;for(b in c)if(c.hasOwnProperty(b)&&c[b]===d)return b;return null};f.getTimezoneOffset=function(d,a){var b,c=[],h=Date.CultureInfo.timezones;for(b=0;b<h.length;b++)h[b].name===d.toUpperCase()&&c.push(b);if(1!==c.length&&a)for(b=0;b<c.length;b++){if(h[c[b]].dst)return h[c[b]].offset}else return h[c[0]].offset;return null};f.getQuarter=function(d){d=d||
new Date;return[1,2,3,4][Math.floor(d.getMonth()/3)]};f.getDaysLeftInQuarter=function(d){d=d||new Date;var a=new Date(d);a.setMonth(a.getMonth()+3-a.getMonth()%3,0);return Math.floor((a-d)/864E5)};a.clone=function(){return new Date(this.getTime())};a.compareTo=function(d){return Date.compare(this,d)};a.equals=function(d){return Date.equals(this,void 0!==d?d:new Date)};a.between=function(d,a){return this.getTime()>=d.getTime()&&this.getTime()<=a.getTime()};a.isAfter=function(d){return 1===this.compareTo(d||
new Date)};a.isBefore=function(d){return-1===this.compareTo(d||new Date)};a.isToday=a.isSameDay=function(d){return this.clone().clearTime().equals((d||new Date).clone().clearTime())};a.addMilliseconds=function(d){this.setTime(this.getTime()+1*d);return this};a.addSeconds=function(d){return this.addMilliseconds(1E3*d)};a.addMinutes=function(d){return this.addMilliseconds(6E4*d)};a.addHours=function(d){return this.addMilliseconds(36E5*d)};a.addDays=function(d){this.setDate(this.getDate()+1*d);return this};
a.addWeekdays=function(d){var a=this.getDay(),b=Math.ceil(d/7);0!==a&&6!==a||this.next().monday();if(5<d||6-a<=d)d+=2*b;return this.addDays(d)};a.addWeeks=function(d){return this.addDays(7*d)};a.addMonths=function(d){var a=this.getDate();this.setDate(1);this.setMonth(this.getMonth()+1*d);this.setDate(Math.min(a,f.getDaysInMonth(this.getFullYear(),this.getMonth())));return this};a.addQuarters=function(d){return this.addMonths(3*d)};a.addYears=function(d){return this.addMonths(12*d)};a.add=function(d){if("number"===
typeof d)return this._orient=d,this;d.milliseconds&&this.addMilliseconds(d.milliseconds);d.seconds&&this.addSeconds(d.seconds);d.minutes&&this.addMinutes(d.minutes);d.hours&&this.addHours(d.hours);d.weeks&&this.addWeeks(d.weeks);d.months&&this.addMonths(d.months);d.years&&this.addYears(d.years);d.days&&this.addDays(d.days);return this};a.getWeek=function(d){var a=new Date(this.valueOf());d?(a.addMinutes(a.getTimezoneOffset()),d=a.clone()):d=this;d=(d.getDay()+6)%7;a.setDate(a.getDate()-d+3);d=a.valueOf();
a.setMonth(0,1);4!==a.getDay()&&a.setMonth(0,1+(4-a.getDay()+7)%7);return 1+Math.ceil((d-a)/6048E5)};a.getISOWeek=function(){return c(this.getWeek(!0))};a.setWeek=function(a){return this.addWeeks(a-this.getWeek()).moveToDayOfWeek(1,1<this.getDay()?-1:1)};a.setQuarter=function(a){a=Math.abs(3*(a-1)+1);return this.setMonth(a,1)};a.getQuarter=function(){return Date.getQuarter(this)};a.getDaysLeftInQuarter=function(){return Date.getDaysLeftInQuarter(this)};var b=function(a,b,e,c){if("undefined"===typeof a)return!1;
if("number"!==typeof a)throw new TypeError(a+" is not a Number.");return a<b||a>e?!1:!0};f.validateMillisecond=function(a){return b(a,0,999,"millisecond")};f.validateSecond=function(a){return b(a,0,59,"second")};f.validateMinute=function(a){return b(a,0,59,"minute")};f.validateHour=function(a){return b(a,0,23,"hour")};f.validateDay=function(a,c,e){return b(a,1,f.getDaysInMonth(c,e),"day")};f.validateWeek=function(a){return b(a,0,53,"week")};f.validateMonth=function(a){return b(a,0,11,"month")};f.validateYear=
function(a){return b(a,-271822,275760,"year")};a.set=function(a){f.validateMillisecond(a.millisecond)&&this.addMilliseconds(a.millisecond-this.getMilliseconds());f.validateSecond(a.second)&&this.addSeconds(a.second-this.getSeconds());f.validateMinute(a.minute)&&this.addMinutes(a.minute-this.getMinutes());f.validateHour(a.hour)&&this.addHours(a.hour-this.getHours());f.validateMonth(a.month)&&this.addMonths(a.month-this.getMonth());f.validateYear(a.year)&&this.addYears(a.year-this.getFullYear());f.validateDay(a.day,
this.getFullYear(),this.getMonth())&&this.addDays(a.day-this.getDate());a.timezone&&this.setTimezone(a.timezone);a.timezoneOffset&&this.setTimezoneOffset(a.timezoneOffset);a.week&&f.validateWeek(a.week)&&this.setWeek(a.week);return this};a.moveToFirstDayOfMonth=function(){return this.set({day:1})};a.moveToLastDayOfMonth=function(){return this.set({day:f.getDaysInMonth(this.getFullYear(),this.getMonth())})};a.moveToNthOccurrence=function(a,b){var e=0;if(0<b)e=b-1;else if(-1===b)return this.moveToLastDayOfMonth(),
this.getDay()!==a&&this.moveToDayOfWeek(a,-1),this;return this.moveToFirstDayOfMonth().addDays(-1).moveToDayOfWeek(a,1).addWeeks(e)};a.moveToDayOfWeek=function(a,b){var e=(a-this.getDay()+7*(b||1))%7;return this.addDays(0===e?e+7*(b||1):e)};a.moveToMonth=function(a,b){var e=(a-this.getMonth()+12*(b||1))%12;return this.addMonths(0===e?e+12*(b||1):e)};a.getOrdinate=function(){var a=this.getDate();return g(a)};a.getOrdinalNumber=function(){return Math.ceil((this.clone().clearTime()-new Date(this.getFullYear(),
0,1))/864E5)+1};a.getTimezone=function(){return f.getTimezoneAbbreviation(this.getUTCOffset(),this.isDaylightSavingTime())};a.setTimezoneOffset=function(a){var b=this.getTimezoneOffset();return this.addMinutes(b- -6*Number(a)/10)};a.setTimezone=function(a){return this.setTimezoneOffset(f.getTimezoneOffset(a))};a.hasDaylightSavingTime=function(){return Date.today().set({month:0,day:1}).getTimezoneOffset()!==Date.today().set({month:6,day:1}).getTimezoneOffset()};a.isDaylightSavingTime=function(){return Date.today().set({month:0,
day:1}).getTimezoneOffset()!==this.getTimezoneOffset()};a.getUTCOffset=function(){var a=-10*this.getTimezoneOffset()/6;if(0>a)return a=(a-1E4).toString(),a.charAt(0)+a.substr(2);a=(a+1E4).toString();return"+"+a.substr(1)};a.getElapsed=function(a){return(a||new Date)-this};a.toISOString||function(){function b(a){a=String(a);1===a.length&&(a="0"+a);return a}a.toISOString=function(){return this.getUTCFullYear()+"-"+b(this.getUTCMonth()+1)+"-"+b(this.getUTCDate())+"T"+b(this.getUTCHours())+":"+b(this.getUTCMinutes())+
":"+b(this.getUTCSeconds())+"."+String((this.getUTCMilliseconds()/1E3).toFixed(3)).slice(2,5)+"Z"}}();void 0===a._toString&&(a._toString=a.toString);var g=function(a){switch(1*a){case 1:case 21:case 31:return"st";case 2:case 22:return"nd";case 3:case 23:return"rd";default:return"th"}};a.toString=function(a,b){var e=this;if(!b&&a&&1===a.length){var f=Date.CultureInfo.formatPatterns;e.t=e.toString;switch(a){case "d":return e.t(f.shortDate);case "D":return e.t(f.longDate);case "F":return e.t(f.fullDateTime);
case "m":return e.t(f.monthDay);case "r":return e.t(f.rfc1123)+" GMT";case "s":return e.t(f.sortableDateTime);case "t":return e.t(f.shortTime);case "T":return e.t(f.longTime);case "u":return e.t(f.universalSortableDateTime);case "y":return e.t(f.yearMonth)}}return a?a.replace(/(\\)?(dd?d?d?|MM?M?M?|yy?y?y?|hh?|HH?|mm?|ss?|tt?|S)/g,function(a){if("\\"===a.charAt(0))return a.replace("\\","");e.h=e.getHours;switch(a){case "hh":return c(13>e.h()?0===e.h()?12:e.h():e.h()-12);case "h":return 13>e.h()?0===
e.h()?12:e.h():e.h()-12;case "HH":return c(e.h());case "H":return e.h();case "mm":return c(e.getMinutes());case "m":return e.getMinutes();case "ss":return c(e.getSeconds());case "s":return e.getSeconds();case "yyyy":return c(e.getFullYear(),4);case "yy":return c(e.getFullYear());case "dddd":return Date.CultureInfo.dayNames[e.getDay()];case "ddd":return Date.CultureInfo.abbreviatedDayNames[e.getDay()];case "dd":return c(e.getDate());case "d":return e.getDate();case "MMMM":return Date.CultureInfo.monthNames[e.getMonth()];
case "MMM":return Date.CultureInfo.abbreviatedMonthNames[e.getMonth()];case "MM":return c(e.getMonth()+1);case "M":return e.getMonth()+1;case "t":return 12>e.h()?Date.CultureInfo.amDesignator.substring(0,1):Date.CultureInfo.pmDesignator.substring(0,1);case "tt":return 12>e.h()?Date.CultureInfo.amDesignator:Date.CultureInfo.pmDesignator;case "S":return g(e.getDate());default:return a}}):this._toString()}})();
(function(){Date.Parsing={Exception:function(a){this.message="Parse error at '"+a.substring(0,10)+" ...'"}};for(var f=Date.Parsing,a=f.Operators={rtoken:function(a){return function(b){var e=b.match(a);if(e)return[e[0],b.substring(e[0].length)];throw new f.Exception(b);}},token:function(b){return function(b){return a.rtoken(RegExp("^s*"+b+"s*"))(b)}},stoken:function(b){return a.rtoken(RegExp("^"+b))},until:function(a){return function(b){for(var e=[],c=null;b.length;){try{c=a.call(this,b)}catch(h){e.push(c[0]);
b=c[1];continue}break}return[e,b]}},many:function(a){return function(b){for(var e=[],c=null;b.length;){try{c=a.call(this,b)}catch(h){break}e.push(c[0]);b=c[1]}return[e,b]}},optional:function(a){return function(b){var e=null;try{e=a.call(this,b)}catch(c){return[null,b]}return[e[0],e[1]]}},not:function(a){return function(b){try{a.call(this,b)}catch(e){return[null,b]}throw new f.Exception(b);}},ignore:function(a){return a?function(b){var e=null,e=a.call(this,b);return[null,e[1]]}:null},product:function(){for(var b=
arguments[0],c=Array.prototype.slice.call(arguments,1),e=[],f=0;f<b.length;f++)e.push(a.each(b[f],c));return e},cache:function(a){var b={},e=null;return function(c){try{e=b[c]=b[c]||a.call(this,c)}catch(h){e=b[c]=h}if(e instanceof f.Exception)throw e;return e}},any:function(){var a=arguments;return function(b){for(var e=null,c=0;c<a.length;c++)if(null!=a[c]){try{e=a[c].call(this,b)}catch(h){e=null}if(e)return e}throw new f.Exception(b);}},each:function(){var a=arguments;return function(b){for(var c=
[],g=null,h=0;h<a.length;h++)if(null!=a[h]){try{g=a[h].call(this,b)}catch(k){throw new f.Exception(b);}c.push(g[0]);b=g[1]}return[c,b]}},all:function(){var a=a;return a.each(a.optional(arguments))},sequence:function(b,c,e){c=c||a.rtoken(/^\s*/);e=e||null;return 1==b.length?b[0]:function(a){for(var h=null,k=null,p=[],m=0;m<b.length;m++){try{h=b[m].call(this,a)}catch(g){break}p.push(h[0]);try{k=c.call(this,h[1])}catch(s){k=null;break}a=k[1]}if(!h)throw new f.Exception(a);if(k)throw new f.Exception(k[1]);
if(e)try{h=e.call(this,h[1])}catch(t){throw new f.Exception(h[1]);}return[p,h?h[1]:a]}},between:function(b,c,e){e=e||b;var f=a.each(a.ignore(b),c,a.ignore(e));return function(a){a=f.call(this,a);return[[a[0][0],r[0][2]],a[1]]}},list:function(b,c,e){c=c||a.rtoken(/^\s*/);e=e||null;return b instanceof Array?a.each(a.product(b.slice(0,-1),a.ignore(c)),b.slice(-1),a.ignore(e)):a.each(a.many(a.each(b,a.ignore(c))),px,a.ignore(e))},set:function(b,c,e){c=c||a.rtoken(/^\s*/);e=e||null;return function(g){for(var h=
null,k=h=null,p=null,m=[[],g],q=!1,s=0;s<b.length;s++){h=k=null;q=1==b.length;try{h=b[s].call(this,g)}catch(t){continue}p=[[h[0]],h[1]];if(0<h[1].length&&!q)try{k=c.call(this,h[1])}catch(u){q=!0}else q=!0;q||0!==k[1].length||(q=!0);if(!q){h=[];for(q=0;q<b.length;q++)s!=q&&h.push(b[q]);h=a.set(h,c).call(this,k[1]);0<h[0].length&&(p[0]=p[0].concat(h[0]),p[1]=h[1])}p[1].length<m[1].length&&(m=p);if(0===m[1].length)break}if(0===m[0].length)return m;if(e){try{k=e.call(this,m[1])}catch(v){throw new f.Exception(m[1]);
}m[1]=k[1]}return m}},forward:function(a,b){return function(c){return a[b].call(this,c)}},replace:function(a,b){return function(c){c=a.call(this,c);return[b,c[1]]}},process:function(a,b){return function(c){c=a.call(this,c);return[b.call(this,c[0]),c[1]]}},min:function(a,b){return function(c){var g=b.call(this,c);if(g[0].length<a)throw new f.Exception(c);return g}}},c=function(a){return function(){var b,c=[],f;1<arguments.length?b=Array.prototype.slice.call(arguments):arguments[0]instanceof Array&&
(b=arguments[0]);if(b){if(f=b.shift(),0<f.length)return b.unshift(f[void 0]),c.push(a.apply(null,b)),b.shift(),c}else return a.apply(null,arguments)}},b="optional not ignore cache".split(/\s/),g=0;g<b.length;g++)a[b[g]]=c(a[b[g]]);c=function(a){return function(){return arguments[0]instanceof Array?a.apply(null,arguments[0]):a.apply(null,arguments)}};b="each any all".split(/\s/);for(g=0;g<b.length;g++)a[b[g]]=c(a[b[g]])})();
(function(){var f=Date,a=function(b){for(var c=[],d=0;d<b.length;d++)b[d]instanceof Array?c=c.concat(a(b[d])):b[d]&&c.push(b[d]);return c};f.Grammar={};f.Translator={hour:function(a){return function(){this.hour=Number(a)}},minute:function(a){return function(){this.minute=Number(a)}},second:function(a){return function(){this.second=Number(a)}},secondAndMillisecond:function(a){return function(){var b=a.match(/^([0-5][0-9])\.([0-9]{1,3})/);this.second=Number(b[1]);this.millisecond=Number(b[2])}},meridian:function(a){return function(){this.meridian=
a.slice(0,1).toLowerCase()}},timezone:function(a){return function(){var b=a.replace(/[^\d\+\-]/g,"");b.length?this.timezoneOffset=Number(b):this.timezone=a.toLowerCase()}},day:function(a){var b=a[0];return function(){this.day=Number(b.match(/\d+/)[0]);if(1>this.day)throw"invalid day";}},month:function(a){return function(){this.month=3===a.length?"jan feb mar apr may jun jul aug sep oct nov dec".indexOf(a)/4:Number(a)-1;if(0>this.month)throw"invalid month";}},year:function(a){return function(){var b=
Number(a);this.year=2<a.length?b:b+(b+2E3<Date.CultureInfo.twoDigitYearMax?2E3:1900)}},rday:function(a){return function(){switch(a){case "yesterday":this.days=-1;break;case "tomorrow":this.days=1;break;case "today":this.days=0;break;case "now":this.days=0,this.now=!0}}},finishExact:function(a){a=a instanceof Array?a:[a];for(var b=0;b<a.length;b++)a[b]&&a[b].call(this);a=new Date;!this.hour&&!this.minute||this.month||this.year||this.day||(this.day=a.getDate());this.year||(this.year=a.getFullYear());
this.month||0===this.month||(this.month=a.getMonth());this.day||(this.day=1);this.hour||(this.hour=0);this.minute||(this.minute=0);this.second||(this.second=0);this.millisecond||(this.millisecond=0);this.meridian&&this.hour&&("p"==this.meridian&&12>this.hour?this.hour+=12:"a"==this.meridian&&12==this.hour&&(this.hour=0));if(this.day>f.getDaysInMonth(this.year,this.month))throw new RangeError(this.day+" is not a valid value for days.");a=new Date(this.year,this.month,this.day,this.hour,this.minute,
this.second,this.millisecond);100>this.year&&a.setFullYear(this.year);this.timezone?a.set({timezone:this.timezone}):this.timezoneOffset&&a.set({timezoneOffset:this.timezoneOffset});return a},finish:function(b){b=b instanceof Array?a(b):[b];if(0===b.length)return null;for(var c=0;c<b.length;c++)"function"==typeof b[c]&&b[c].call(this);b=f.today();if(!this.now||this.unit||this.operator)this.now&&(b=new Date);else return new Date;var c=!!(this.days&&null!==this.days||this.orient||this.operator),d,e,
g;g="past"==this.orient||"subtract"==this.operator?-1:1;this.now||-1==="hour minute second".indexOf(this.unit)||b.setTimeToNow();!this.month&&0!==this.month||-1=="year day hour minute second".indexOf(this.unit)||(this.value=this.month+1,this.month=null,c=!0);c||!this.weekday||this.day||this.days||(d=Date[this.weekday](),this.day=d.getDate(),this.month||(this.month=d.getMonth()),this.year=d.getFullYear());c&&this.weekday&&"month"!=this.unit&&(this.unit="day",d=f.getDayNumberFromName(this.weekday)-
b.getDay(),e=7,this.days=d?(d+g*e)%e:g*e);this.month&&"day"==this.unit&&this.operator&&(this.value=this.month+1,this.month=null);null!=this.value&&null!=this.month&&null!=this.year&&(this.day=1*this.value);this.month&&!this.day&&this.value&&(b.set({day:1*this.value}),c||(this.day=1*this.value));this.month||!this.value||"month"!=this.unit||this.now||(this.month=this.value,c=!0);c&&(this.month||0===this.month)&&"year"!=this.unit&&(this.unit="month",d=this.month-b.getMonth(),e=12,this.months=d?(d+g*
e)%e:g*e,this.month=null);this.unit||(this.unit="day");if(!this.value&&this.operator&&null!==this.operator&&this[this.unit+"s"]&&null!==this[this.unit+"s"])this[this.unit+"s"]=this[this.unit+"s"]+("add"==this.operator?1:-1)+(this.value||0)*g;else if(null==this[this.unit+"s"]||null!=this.operator)this.value||(this.value=1),this[this.unit+"s"]=this.value*g;this.meridian&&this.hour&&("p"==this.meridian&&12>this.hour?this.hour+=12:"a"==this.meridian&&12==this.hour&&(this.hour=0));!this.weekday||this.day||
this.days||(d=Date[this.weekday](),this.day=d.getDate(),d.getMonth()!==b.getMonth()&&(this.month=d.getMonth()));!this.month&&0!==this.month||this.day||(this.day=1);if(!this.orient&&!this.operator&&"week"==this.unit&&this.value&&!this.day&&!this.month)return Date.today().setWeek(this.value);c&&this.timezone&&this.day&&this.days&&(this.day=this.days);return c?b.add(this):b.set(this)}};var c=f.Parsing.Operators,b=f.Grammar,g=f.Translator,d;b.datePartDelimiter=c.rtoken(/^([\s\-\.\,\/\x27]+)/);b.timePartDelimiter=
c.stoken(":");b.whiteSpace=c.rtoken(/^\s*/);b.generalDelimiter=c.rtoken(/^(([\s\,]|at|@|on)+)/);var n={};b.ctoken=function(a){var b=n[a];if(!b){for(var b=Date.CultureInfo.regexPatterns,d=a.split(/\s+/),e=[],f=0;f<d.length;f++)e.push(c.replace(c.rtoken(b[d[f]]),d[f]));b=n[a]=c.any.apply(null,e)}return b};b.ctoken2=function(a){return c.rtoken(Date.CultureInfo.regexPatterns[a])};b.h=c.cache(c.process(c.rtoken(/^(0[0-9]|1[0-2]|[1-9])/),g.hour));b.hh=c.cache(c.process(c.rtoken(/^(0[0-9]|1[0-2])/),g.hour));
b.H=c.cache(c.process(c.rtoken(/^([0-1][0-9]|2[0-3]|[0-9])/),g.hour));b.HH=c.cache(c.process(c.rtoken(/^([0-1][0-9]|2[0-3])/),g.hour));b.m=c.cache(c.process(c.rtoken(/^([0-5][0-9]|[0-9])/),g.minute));b.mm=c.cache(c.process(c.rtoken(/^[0-5][0-9]/),g.minute));b.s=c.cache(c.process(c.rtoken(/^([0-5][0-9]|[0-9])/),g.second));b.ss=c.cache(c.process(c.rtoken(/^[0-5][0-9]/),g.second));b["ss.s"]=c.cache(c.process(c.rtoken(/^[0-5][0-9]\.[0-9]{1,3}/),g.secondAndMillisecond));b.hms=c.cache(c.sequence([b.H,b.m,
b.s],b.timePartDelimiter));b.t=c.cache(c.process(b.ctoken2("shortMeridian"),g.meridian));b.tt=c.cache(c.process(b.ctoken2("longMeridian"),g.meridian));b.z=c.cache(c.process(c.rtoken(/^((\+|\-)\s*\d\d\d\d)|((\+|\-)\d\d\:?\d\d)/),g.timezone));b.zz=c.cache(c.process(c.rtoken(/^((\+|\-)\s*\d\d\d\d)|((\+|\-)\d\d\:?\d\d)/),g.timezone));b.zzz=c.cache(c.process(b.ctoken2("timezone"),g.timezone));b.timeSuffix=c.each(c.ignore(b.whiteSpace),c.set([b.tt,b.zzz]));b.time=c.each(c.optional(c.ignore(c.stoken("T"))),
b.hms,b.timeSuffix);b.d=c.cache(c.process(c.each(c.rtoken(/^([0-2]\d|3[0-1]|\d)/),c.optional(b.ctoken2("ordinalSuffix"))),g.day));b.dd=c.cache(c.process(c.each(c.rtoken(/^([0-2]\d|3[0-1])/),c.optional(b.ctoken2("ordinalSuffix"))),g.day));b.ddd=b.dddd=c.cache(c.process(b.ctoken("sun mon tue wed thu fri sat"),function(a){return function(){this.weekday=a}}));b.M=c.cache(c.process(c.rtoken(/^(1[0-2]|0\d|\d)/),g.month));b.MM=c.cache(c.process(c.rtoken(/^(1[0-2]|0\d)/),g.month));b.MMM=b.MMMM=c.cache(c.process(b.ctoken(Date.CultureInfo.abbreviatedMonthNames.join("")),
g.month));b.y=c.cache(c.process(c.rtoken(/^(\d\d?)/),g.year));b.yy=c.cache(c.process(c.rtoken(/^(\d\d)/),g.year));b.yyy=c.cache(c.process(c.rtoken(/^(\d\d?\d?\d?)/),g.year));b.yyyy=c.cache(c.process(c.rtoken(/^(\d\d\d\d)/),g.year));d=function(){return c.each(c.any.apply(null,arguments),c.not(b.ctoken2("timeContext")))};b.day=d(b.d,b.dd);b.month=d(b.M,b.MMM);b.year=d(b.yyyy,b.yy);b.orientation=c.process(b.ctoken("past future"),function(a){return function(){this.orient=a}});b.operator=c.process(b.ctoken("add subtract"),
function(a){return function(){this.operator=a}});b.rday=c.process(b.ctoken("yesterday tomorrow today now"),g.rday);b.unit=c.process(b.ctoken("second minute hour day week month year"),function(a){return function(){this.unit=a}});b.value=c.process(c.rtoken(/^\d\d?(st|nd|rd|th)?/),function(a){return function(){this.value=a.replace(/\D/g,"")}});b.expression=c.set([b.rday,b.operator,b.value,b.unit,b.orientation,b.ddd,b.MMM]);d=function(){return c.set(arguments,b.datePartDelimiter)};b.mdy=d(b.ddd,b.month,
b.day,b.year);b.ymd=d(b.ddd,b.year,b.month,b.day);b.dmy=d(b.ddd,b.day,b.month,b.year);b.date=function(a){return(b[Date.CultureInfo.dateElementOrder]||b.mdy).call(this,a)};b.format=c.process(c.many(c.any(c.process(c.rtoken(/^(dd?d?d?(?!e)|MM?M?M?|yy?y?y?|hh?|HH?|mm?|ss?|tt?|zz?z?)/),function(a){if(b[a])return b[a];throw f.Parsing.Exception(a);}),c.process(c.rtoken(/^[^dMyhHmstz]+/),function(a){return c.ignore(c.stoken(a))}))),function(a){return c.process(c.each.apply(null,a),g.finishExact)});var e=
{},l=function(a){e[a]=e[a]||b.format(a)[0];return e[a]};b.allformats=function(a){var b=[];if(a instanceof Array)for(var c=0;c<a.length;c++)b.push(l(a[c]));else b.push(l(a));return b};b.formats=function(a){if(a instanceof Array){for(var b=[],d=0;d<a.length;d++)b.push(l(a[d]));return c.any.apply(null,b)}return l(a)};b._formats=b.formats('"yyyy-MM-ddTHH:mm:ssZ";yyyy-MM-ddTHH:mm:ss.sz;yyyy-MM-ddTHH:mm:ssZ;yyyy-MM-ddTHH:mm:ssz;yyyy-MM-ddTHH:mm:ss;yyyy-MM-ddTHH:mmZ;yyyy-MM-ddTHH:mmz;yyyy-MM-ddTHH:mm;ddd, MMM dd, yyyy H:mm:ss tt;ddd MMM d yyyy HH:mm:ss zzz;MMddyyyy;ddMMyyyy;Mddyyyy;ddMyyyy;Mdyyyy;dMyyyy;yyyy;Mdyy;dMyy;d'.split(";"));
b._start=c.process(c.set([b.date,b.time,b.expression],b.generalDelimiter,b.whiteSpace),g.finish);b.start=function(a){try{var c=b._formats.call({},a);if(0===c[1].length)return c}catch(d){}return b._start.call({},a)};f._parse||(f._parse=f.parse);f.parse=function(a){var b,c,d,e=null;if(!a)return null;if(a instanceof Date)return a.clone();a=(b=a.match(/\b(\d+)(?:st|nd|rd|th)\b/))&&2===b.length?a.replace(b[0],b[1]):a;if("+"!==a[0]&&"-"!==a[0])try{c=new Date(Date._parse(a)),d=c.getTime()}catch(g){}if(void 0!==
d&&d===d)return c;try{e=f.Grammar.start.call({},a.replace(/^\s*(\S*(\s+\S+)*)\s*$/,"$1"))}catch(l){return null}return 0===e[1].length?e[0]:null};Date.getParseFunction=function(a){var b=Date.Grammar.allformats(a);return function(a){for(var c=null,d=0;d<b.length;d++){try{c=b[d].call({},a)}catch(e){continue}if(0===c[1].length)return c[0]}return null}};f.parseExact=function(a,b){return f.getParseFunction(b)(a)}})();
(function(){var f=Date,a=f.prototype,c=Number.prototype;a._orient=1;a._nth=null;a._is=!1;a._same=!1;a._isSecond=!1;c._dateElement="days";a.next=function(){this._orient=1;return this};f.next=function(){return f.today().next()};a.last=a.prev=a.previous=function(){this._orient=-1;return this};f.last=f.prev=f.previous=function(){return f.today().last()};a.is=function(){this._is=!0;return this};a.same=function(){this._same=!0;this._isSecond=!1;return this};a.today=function(){return this.same().day()};
a.weekday=function(){return this._is?(this._is=!1,!this.is().sat()&&!this.is().sun()):!1};a.at=function(a){return"string"===typeof a?f.parse(this.toString("d")+" "+a):this.set(a)};c.fromNow=c.after=function(a){var b={};b[this._dateElement]=this;return(a?a.clone():new Date).add(b)};c.ago=c.before=function(a){var b={};b[this._dateElement+"s"]=-1*this;return(a?a.clone():new Date).add(b)};var b="sunday monday tuesday wednesday thursday friday saturday".split(/\s/),g="january february march april may june july august september october november december".split(/\s/),
d="Millisecond Second Minute Hour Day Week Month Year Quarter Weekday".split(/\s/),n="Milliseconds Seconds Minutes Hours Date Week Month FullYear Quarter".split(/\s/),e="final first second third fourth fifth".split(/\s/);a.toObject=function(){for(var a={},b=0;b<d.length;b++)this["get"+n[b]]&&(a[d[b].toLowerCase()]=this["get"+n[b]]());return a};f.fromObject=function(a){a.week=null;return Date.today().set(a)};for(var l=function(a){return function(){if(this._is)return this._is=!1,this.getDay()===a;if(null!==
this._nth){this._isSecond&&this.addSeconds(-1*this._orient);this._isSecond=!1;var b=this._nth;this._nth=null;var c=this.clone().moveToLastDayOfMonth();this.moveToNthOccurrence(a,b);if(this>c)throw new RangeError(f.getDayName(a)+" does not occur "+b+" times in the month of "+f.getMonthName(c.getMonth())+" "+c.getFullYear()+".");return this}return this.moveToDayOfWeek(a,this._orient)}},h=function(a){return function(){var b=f.today(),c=a-b.getDay();0===a&&1===Date.CultureInfo.firstDayOfWeek&&0!==b.getDay()&&
(c+=7);return b.addDays(c)}},k=0;k<b.length;k++)f[b[k].toUpperCase()]=f[b[k].toUpperCase().substring(0,3)]=k,f[b[k]]=f[b[k].substring(0,3)]=h(k),a[b[k]]=a[b[k].substring(0,3)]=l(k);b=function(a){return function(){return this._is?(this._is=!1,this.getMonth()===a):this.moveToMonth(a,this._orient)}};l=function(a){return function(){return f.today().set({month:a,day:1})}};for(h=0;h<g.length;h++)f[g[h].toUpperCase()]=f[g[h].toUpperCase().substring(0,3)]=h,f[g[h]]=f[g[h].substring(0,3)]=l(h),a[g[h]]=a[g[h].substring(0,
3)]=b(h);b=function(a){return function(b){if(this._isSecond)return this._isSecond=!1,this;if(this._same){this._same=this._is=!1;var c=this.toObject();b=(b||new Date).toObject();for(var e="",f=a.toLowerCase(),g=d.length-1;-1<g;g--){e=d[g].toLowerCase();if(c[e]!==b[e])return!1;if(f===e)break}return!0}"s"!==a.substring(a.length-1)&&(a+="s");return this["add"+a](this._orient)}};l=function(a){return function(){this._dateElement=a;return this}};for(h=0;h<d.length;h++)g=d[h].toLowerCase(),a[g]=a[g+"s"]=
b(d[h]),c[g]=c[g+"s"]=l(g+"s");a._ss=b("Second");c=function(a){return function(b){if(this._same)return this._ss(b);if(b||0===b)return this.moveToNthOccurrence(b,a);this._nth=a;return 2!==a||void 0!==b&&null!==b?this:(this._isSecond=!0,this.addSeconds(this._orient))}};for(g=0;g<e.length;g++)a[e[g]]=0===g?c(-1):c(g)})();
(function(){var f=Date,a=f.prototype,c=[],b=function(a,b){b||(b=2);return("000"+a).slice(-1*b)};f.normalizeFormat=function(a){return a};f.strftime=function(a,b){return(new Date(1E3*b)).$format(a)};f.strtotime=function(a){a=f.parse(a);a.addMinutes(-1*a.getTimezoneOffset());return Math.round(f.UTC(a.getUTCFullYear(),a.getUTCMonth(),a.getUTCDate(),a.getUTCHours(),a.getUTCMinutes(),a.getUTCSeconds(),a.getUTCMilliseconds())/1E3)};a.$format=function(a){var d=this,n,e=function(a,b){c.push(a);return d.toString(a,
b)};return a?a.replace(/(%|\\)?.|%%/g,function(a){if("\\"===a.charAt(0)||"%%"===a.substring(0,2))return a.replace("\\","").replace("%%","%");switch(a){case "d":case "%d":return e("dd");case "D":case "%a":return e("ddd");case "j":case "%e":return e("d",!0);case "l":case "%A":return e("dddd");case "N":case "%u":return d.getDay()+1;case "S":return e("S");case "w":case "%w":return d.getDay();case "z":return d.getOrdinalNumber();case "%j":return b(d.getOrdinalNumber(),3);case "%U":a=d.clone().set({month:0,
day:1}).addDays(-1).moveToDayOfWeek(0);var g=d.clone().addDays(1).moveToDayOfWeek(0,-1);return g<a?"00":b((g.getOrdinalNumber()-a.getOrdinalNumber())/7+1);case "W":case "%V":return d.getISOWeek();case "%W":return b(d.getWeek());case "F":case "%B":return e("MMMM");case "m":case "%m":return e("MM");case "M":case "%b":case "%h":return e("MMM");case "n":return e("M");case "t":return f.getDaysInMonth(d.getFullYear(),d.getMonth());case "L":return f.isLeapYear(d.getFullYear())?1:0;case "o":case "%G":return d.setWeek(d.getISOWeek()).toString("yyyy");
case "%g":return d.$format("%G").slice(-2);case "Y":case "%Y":return e("yyyy");case "y":case "%y":return e("yy");case "a":case "%p":return e("tt").toLowerCase();case "A":return e("tt").toUpperCase();case "g":case "%I":return e("h");case "G":return e("H");case "h":return e("hh");case "H":case "%H":return e("HH");case "i":case "%M":return e("mm");case "s":case "%S":return e("ss");case "u":return b(d.getMilliseconds(),3);case "I":return d.isDaylightSavingTime()?1:0;case "O":return d.getUTCOffset();case "P":return n=
d.getUTCOffset(),n.substring(0,n.length-2)+":"+n.substring(n.length-2);case "e":case "T":case "%z":case "%Z":return d.getTimezone();case "Z":return-60*d.getTimezoneOffset();case "B":return a=new Date,Math.floor((3600*a.getHours()+60*a.getMinutes()+a.getSeconds()+60*(a.getTimezoneOffset()+60))/86.4);case "c":return d.toISOString().replace(/\"/g,"");case "U":return f.strtotime("now");case "%c":return e("d")+" "+e("t");case "%C":return Math.floor(d.getFullYear()/100+1);case "%D":return e("MM/dd/yy");
case "%n":return"\\n";case "%t":return"\\t";case "%r":return e("hh:mm tt");case "%R":return e("H:mm");case "%T":return e("H:mm:ss");case "%x":return e("d");case "%X":return e("t");default:return c.push(a),a}}):this._toString()};a.format||(a.format=a.$format)})();
var TimeSpan=function(f,a,c,b,g){for(var d="days hours minutes seconds milliseconds".split(/\s+/),n=function(a){return function(){return this[a]}},e=function(a){return function(b){this[a]=b;return this}},l=0;l<d.length;l++){var h=d[l],k=h.slice(0,1).toUpperCase()+h.slice(1);TimeSpan.prototype[h]=0;TimeSpan.prototype["get"+k]=n(h);TimeSpan.prototype["set"+k]=e(h)}4===arguments.length?(this.setDays(f),this.setHours(a),this.setMinutes(c),this.setSeconds(b)):5===arguments.length?(this.setDays(f),this.setHours(a),
this.setMinutes(c),this.setSeconds(b),this.setMilliseconds(g)):1===arguments.length&&"number"===typeof f&&(d=0>f?-1:1,this.setMilliseconds(Math.abs(f)),this.setDays(Math.floor(this.getMilliseconds()/864E5)*d),this.setMilliseconds(this.getMilliseconds()%864E5),this.setHours(Math.floor(this.getMilliseconds()/36E5)*d),this.setMilliseconds(this.getMilliseconds()%36E5),this.setMinutes(Math.floor(this.getMilliseconds()/6E4)*d),this.setMilliseconds(this.getMilliseconds()%6E4),this.setSeconds(Math.floor(this.getMilliseconds()/
1E3)*d),this.setMilliseconds(this.getMilliseconds()%1E3),this.setMilliseconds(this.getMilliseconds()*d));this.getTotalMilliseconds=function(){return 864E5*this.getDays()+36E5*this.getHours()+6E4*this.getMinutes()+1E3*this.getSeconds()};this.compareTo=function(a){var b=new Date(1970,1,1,this.getHours(),this.getMinutes(),this.getSeconds());a=null===a?new Date(1970,1,1,0,0,0):new Date(1970,1,1,a.getHours(),a.getMinutes(),a.getSeconds());return b<a?-1:b>a?1:0};this.equals=function(a){return 0===this.compareTo(a)};
this.add=function(a){return null===a?this:this.addSeconds(a.getTotalMilliseconds()/1E3)};this.subtract=function(a){return null===a?this:this.addSeconds(-a.getTotalMilliseconds()/1E3)};this.addDays=function(a){return new TimeSpan(this.getTotalMilliseconds()+864E5*a)};this.addHours=function(a){return new TimeSpan(this.getTotalMilliseconds()+36E5*a)};this.addMinutes=function(a){return new TimeSpan(this.getTotalMilliseconds()+6E4*a)};this.addSeconds=function(a){return new TimeSpan(this.getTotalMilliseconds()+
1E3*a)};this.addMilliseconds=function(a){return new TimeSpan(this.getTotalMilliseconds()+a)};this.get12HourHour=function(){return 12<this.getHours()?this.getHours()-12:0===this.getHours()?12:this.getHours()};this.getDesignator=function(){return 12>this.getHours()?Date.CultureInfo.amDesignator:Date.CultureInfo.pmDesignator};this.toString=function(a){this._toString=function(){return null!==this.getDays()&&0<this.getDays()?this.getDays()+"."+this.getHours()+":"+this.p(this.getMinutes())+":"+this.p(this.getSeconds()):
this.getHours()+":"+this.p(this.getMinutes())+":"+this.p(this.getSeconds())};this.p=function(a){return 2>a.toString().length?"0"+a:a};var b=this;return a?a.replace(/dd?|HH?|hh?|mm?|ss?|tt?/g,function(a){switch(a){case "d":return b.getDays();case "dd":return b.p(b.getDays());case "H":return b.getHours();case "HH":return b.p(b.getHours());case "h":return b.get12HourHour();case "hh":return b.p(b.get12HourHour());case "m":return b.getMinutes();case "mm":return b.p(b.getMinutes());case "s":return b.getSeconds();
case "ss":return b.p(b.getSeconds());case "t":return(12>b.getHours()?Date.CultureInfo.amDesignator:Date.CultureInfo.pmDesignator).substring(0,1);case "tt":return 12>b.getHours()?Date.CultureInfo.amDesignator:Date.CultureInfo.pmDesignator}}):this._toString()};return this};Date.prototype.getTimeOfDay=function(){return new TimeSpan(0,this.getHours(),this.getMinutes(),this.getSeconds(),this.getMilliseconds())};
var TimePeriod=function(f,a,c,b,g,d,n){for(var e="years months days hours minutes seconds milliseconds".split(/\s+/),l=function(a){return function(){return this[a]}},h=function(a){return function(b){this[a]=b;return this}},k=0;k<e.length;k++){var p=e[k],m=p.slice(0,1).toUpperCase()+p.slice(1);TimePeriod.prototype[p]=0;TimePeriod.prototype["get"+m]=l(p);TimePeriod.prototype["set"+m]=h(p)}if(7===arguments.length)this.years=f,this.months=a,this.setDays(c),this.setHours(b),this.setMinutes(g),this.setSeconds(d),
this.setMilliseconds(n);else if(2===arguments.length&&arguments[0]instanceof Date&&arguments[1]instanceof Date){e=f.clone();l=a.clone();h=e.clone();k=e>l?-1:1;this.years=l.getFullYear()-e.getFullYear();h.addYears(this.years);1===k?h>l&&0!==this.years&&this.years--:h<l&&0!==this.years&&this.years++;e.addYears(this.years);if(1===k)for(;e<l&&e.clone().addMonths(1)<=l;)e.addMonths(1),this.months++;else for(;e>l&&e.clone().addDays(-e.getDaysInMonth())>l;)e.addMonths(-1),this.months--;e=l-e;0!==e&&(e=new TimeSpan(e),
this.setDays(e.getDays()),this.setHours(e.getHours()),this.setMinutes(e.getMinutes()),this.setSeconds(e.getSeconds()),this.setMilliseconds(e.getMilliseconds()))}return this};
