<?php

/*
 * This file is part of the Active Collab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

namespace ActiveCollab\Command;

use Angie\Command\Command;
use Angie\Search;
use Exception;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * @package Angie\Command
 */
final class RebuildTasksSearchIndexCommand extends Command
{
    /**
     * {@inheritdoc}
     */
    protected function configure()
    {
        parent::configure();

        $this->setDescription('Rebuild tasks search index');
    }

    /**
     * {@inheritdoc}
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $microtime = microtime(true);

        try {
            $action = Search::getRebuildActions()['rebuild_project_tasks'];

            if (is_callable($action['callback'])) {
                $output->writeln("<info>OK:</info> $action[label]");
                call_user_func($action['callback']);
            } else {
                return $this->abort("Rebuild action 'rebuild_project_tasks' has no proper execution method", 1, $input, $output);
            }
        } catch (Exception $e) {
            return $this->abortDueToException($e, $input, $output);
        }

        return $this->success('Done in ' . round(microtime(true) - $microtime, 2) . 's', $input, $output);
    }
}
