<?php

/*
 * This file is part of the Active Collab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

namespace ActiveCollab\Command\User;

use AngieApplication;
use Companies;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Question\Question;
use Users;

/**
 * @package ActiveCollab\Command
 */
class AddCommand extends UserCommand
{
    /**
     * {@inheritdoc}
     */
    public function configure()
    {
        parent::configure();

        $this->setDescription('Add a user')
            ->addArgument('type', InputArgument::REQUIRED)
            ->addArgument('email_address', InputArgument::REQUIRED)
            ->addArgument('first_name', InputArgument::OPTIONAL)
            ->addArgument('last_name', InputArgument::OPTIONAL)
            ->addOption('password', 'p', InputOption::VALUE_REQUIRED);
    }

    /**
     * {@inheritdoc}
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $type = $this->getValidUserType($input->getArgument('type'));
        $email = $input->getArgument('email_address');

        if (!is_valid_email($email)) {
            return $this->abort('Email must be valid email address', 1, $input, $output);
        }

        $password = $input->getOption('password');

        if (empty($password)) {
            if ($input->isInteractive()) {
                $password = $this->getHelper('question')->ask($input, $output, (new Question('Enter password: '))->setHidden(true)->setHiddenFallback(false));

                if (empty($password)) {
                    return $this->abort('Password is required', 1, $input, $output);
                }
            } else {
                return $this->abort('Password is required', 1, $input, $output);
            }
        }

        Users::create([
            'type' => $type,
            'company_id' => Companies::getOwnerCompanyId(),
            'email' => $email,
            'password' => $password,
            'first_name' => $input->getArgument('first_name'),
            'last_name' => $input->getArgument('last_name'),
            'created_by_id' => 1,
            'updated_by_id' => 1,
        ]);

        AngieApplication::cache()->clear();

        return $this->success('Done', $input, $output);
    }
}
