<?php

/*
 * This file is part of the Active Collab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

namespace ActiveCollab\Command\User;

use Exception;
use RuntimeException;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Users;

/**
 * @package ActiveCollab\Command
 */
class DeleteCommand extends UserCommand
{
    /**
     * {@inheritdoc}
     */
    public function configure()
    {
        parent::configure();

        $this->setDescription('Delete a user account')
            ->addArgument('email_address', InputArgument::REQUIRED);
    }

    /**
     * {@inheritdoc}
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $email_address = $input->getArgument('email_address');

        if (!is_valid_email($email_address)) {
            return $this->abort('Email must be valid email address', 1, $input, $output);
        }

        try {
            $user = Users::findByEmail($email_address);

            if (empty($user)) {
                throw new RuntimeException("User {$email_address} not found");
            }

            if (Users::isLastOwner($user)) {
                throw new RuntimeException("Last owner can't be deleted");
            }

            Users::scrap($user, true);

            return $this->success("User #{$user->getId()} has been deleted", $input, $output);
        } catch (Exception $e) {
            return $this->abortDueToException($e, $input, $output);
        }
    }
}
