<?php

/*
 * This file is part of the Active Collab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

namespace ActiveCollab\Command\User;

use Symfony\Component\Console\Helper\Table;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Users;

/**
 * @package ActiveCollab\Command
 */
class ListCommand extends UserCommand
{
    /**
     * {@inheritdoc}
     */
    public function configure()
    {
        parent::configure();

        $this->setDescription('List user accounts')
            ->addArgument('type', InputArgument::OPTIONAL, 'Filter by user type');
    }

    /**
     * {@inheritdoc}
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $type = $input->getArgument('type');

        if ($type) {
            $type = $this->getValidUserType($type);

            $users = Users::find([
                'conditions' => ['type = ? AND is_archived = ? AND is_trashed = ?', $type, false, false],
            ]);
        } else {
            $users = Users::find([
                'conditions' => ['is_archived = ? AND is_trashed = ?', false, false],
            ]);
        }

        $result = [];

        if ($users) {
            /** @var \User $user */
            foreach ($users as $user) {
                $result[] = ['id' => $user->getId(), 'display_name' => $user->getDisplayName(), 'email' => $user->getEmail()];
            }
        }

        if ($input->getOption('json')) {
            $output->writeln(json_encode($result));
        } else {
            $table = new Table($output);
            $table->setHeaders(['ID', 'Name', 'Email']);
            $table->setRows($result);
            $table->render();
        }

        return 0;
    }
}
