<?php

/*
 * This file is part of the Active Collab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

/**
  * Angie storage delegate implementation.
  *
  * @package angie.library.application
  * @subpackage delegates
  */
 class AngieStorageDelegate extends AngieDelegate
 {
     /**
     * @var StorageAdapterInterface
     */
    private $adapter;

     /**
      * Return the sum of all file sizes used across the system.
      *
      * @return mixed
      */
     public function getDiskUsage()
     {
         if (!$this->adapter) {
             $this->adapter = $this->resolveAdapterByIntegration();
         }

         return $this->adapter->getDiskUsage();
     }

     /**
      * Return has the disk quota for on demand instances been reached.
      *
      * @param  bool|false $be_graceful
      * @return bool
      */
     public function isDiskFull($be_graceful = false)
     {
         if (!$this->adapter) {
             $this->adapter = $this->resolveAdapterByIntegration();
         }

         return $this->adapter->isDiskFull($be_graceful);
     }

     /**
      * Delete file by location.
      *
      * @param  string $location
      * @param  string $type
      */
     public function deleteFileByLocationAndType($location, $type)
     {
         if (in_array($type, [WarehouseFile::class, WarehouseUploadedFile::class, WarehouseAttachment::class])) {
             (new OnDemandFilesStorage())->deleteFile($location);
         } elseif (in_array($type, [LocalFile::class, LocalUploadedFile::class, LocalAttachment::class])) {
             (new LocalFilesStorage())->deleteFile($location);
         }
     }

     /**
      * Returns OnDemandFilesStorage adapter if WarehouseIntegration is in use or LocalFilesStorage adapter otherwise.
      *
      * @return LocalFilesStorage|OnDemandFilesStorage
      */
     public function resolveAdapterByIntegration()
     {
         $warehouse_integration = Integrations::findFirstByType(WarehouseIntegration::class);
         $adapter = $warehouse_integration && $warehouse_integration->isInUse()
             ? new OnDemandFilesStorage()
             : new LocalFilesStorage();

         return $adapter;
     }
 }
