<?php

/*
 * This file is part of the Active Collab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

use Sabre\VObject\Component\VCalendar;

/**
 * Calendar feed element interface.
 *
 * @package angie.frameworks.calendars
 * @subpackage models
 */
interface ICalendarFeedElement
{
    /**
     * @param VCalendar $calendar
     * @param IUser     $user
     * @param string    $summary_prefix
     * @param string    $summary_sufix
     */
    public function exportToCalendar(VCalendar &$calendar, IUser $user, $summary_prefix = '', $summary_sufix = '');
}
