<?php

/*
 * This file is part of the Active Collab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

use Angie\Http\Request;
use Angie\Search;

AngieApplication::useController('auth_required', EnvironmentFramework::INJECT_INTO);

/**
 * Search controller.
 *
 * @package angie.frameworks.environment
 * @subpackage controllers
 */
class FwSearchController extends AuthRequiredController
{
    /**
     * Query the index.
     *
     * @param  Request $request
     * @param  User    $user
     * @return array
     */
    public function query(Request $request, User $user)
    {
        return Search::query($request->get('q'), $user, Search::getCriterionsFromRequest($request->get()), $request->getPage());
    }

    /**
     * Suggest based on query typed so far.
     *
     * @param  Request $request
     * @param  User    $user
     * @return array
     */
    public function suggest(Request $request, User $user)
    {
        return Search::suggest($request->get('q'), $user);
    }
}
