<?php

/*
 * This file is part of the Active Collab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

AngieApplication::useController('integration_singletons', EnvironmentFramework::INJECT_INTO);

use ActiveCollab\ActiveCollabJobs\Jobs\Search\TestConnection as SearchConnectionTest;
use Angie\Http\Request;
use Angie\Http\Response;

/**
 * Search integrations controller.
 *
 * @package angie.frameworks.environment
 * @subpackage controllers
 */
class FwSearchIntegrationController extends IntegrationSingletonsController
{
    /**
     * {@inheritdoc}
     */
    protected function __before(Request $request, $user)
    {
        $before_result = parent::__before($request, $user);

        if ($before_result !== null) {
            return $before_result;
        }

        if (!($this->active_integration instanceof SearchIntegration)) {
            return Response::CONFLICT;
        }
    }

    /**
     * @param  Request $request
     * @return array
     */
    public function test_connection(Request $request)
    {
        $error_message = null;

        try {
            $post = $request->post();
            $post['instance_id'] = AngieApplication::getAccountId();

            $test = AngieApplication::jobs()->execute(new SearchConnectionTest($post));

            if (is_string($test)) {
                $error_message = $test;
            }
        } catch (Exception $e) {
            $error_message = $e->getMessage();
        }

        return ['ok' => empty($error_message), 'error' => (string) $error_message];
    }
}
