<?php

/*
 * This file is part of the Active Collab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

interface StorageAdapterInterface
{
    /**
     * Return the sum of all file sizes used in across the system.
     *
     * @return int
     */
    public function getDiskUsage();

    /**
     * Return has the disk quota for on demand instances been reached.
     *
     * @param  bool|false $be_graceful
     * @return bool
     */
    public function isDiskFull($be_graceful = false);

    /**
     * Delete file by location.
     *
     * @param string $location
     */
    public function deleteFile($location);
}
