<?php

/*
 * This file is part of the Active Collab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

/**
 * Disk space system notification.
 *
 * @package angie.environment
 * @subpackage models
 */
class DiskSpaceSystemNotifications extends SystemNotifications
{
    /**
     * Return 'type' attribute for polymorh model creation.
     *
     * @return mixed|string
     */
    public static function getType()
    {
        return 'DiskSpaceSystemNotification';
    }

    /**
     * Return true if this notification should ne raised.
     *
     * @return bool
     */
    public static function shouldBeRaised()
    {
        if (defined('ON_DEMAND_PLAN_MAX_DISK_SPACE')) {
            return AngieApplication::isOnDemand() && AngieApplication::getStorageUsage() > ON_DEMAND_PLAN_MAX_DISK_SPACE;
        } else {
            return false;
        }
    }
}
