<?php

/*
 * This file is part of the Active Collab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

/**
 * Free Trial system notification.
 *
 * @package angie.environment.free_trial
 * @subpackage models
 */
class FreeTrialSystemNotification extends SystemNotification
{
    /**
     * Return notification title.
     *
     * @return mixed
     */
    public function getTitle()
    {
        if (FreeTrialSystemNotifications::isFreeTrialExpired()) {
            return lang('Free Trial Ended');
        } else {
            return lang('Free Trial Ends Soon');
        }
    }

    /**
     * Return notification body.
     *
     * @return mixed
     */
    public function getBody()
    {
        if (FreeTrialSystemNotifications::isFreeTrialExpired()) {
            $message = lang('Your free trial has ended.') . ' ' . lang('Only owner users are able to log-in now. Please buy a cloud subscription or a self-hosted license.');
        } else {
            if (FreeTrialSystemNotifications::freeTrialExpiresOn()) {
                $days_to_expiration = FreeTrialSystemNotifications::freeTrialExpiresInDays();

                if ($days_to_expiration == 0) {
                    $message = lang('Your free trial ends today.');
                } else {
                    if ($days_to_expiration == 1) {
                        $message = lang('Your free trial ends tomorrow.');
                    } else {
                        $message = lang('Your free trial ends in :days days.', ['days' => $days_to_expiration]);
                    }
                }

                $message .= ' ' . lang('Make sure you buy Active Collab so your team can continue working.');
            }
        }

        return $message;
    }

    /**
     * Return notification action.
     *
     * @return mixed
     */
    public function getAction()
    {
        return lang('Buy Now!');
    }

    /**
     * Return notification url.
     *
     * @return mixed
     */
    public function getUrl()
    {
        return 'https://my.activecollab.com/accounts/feather/' . AngieApplication::getAccountId() . '/change';
    }

    /**
     * Return is permanent.
     *
     * @return mixed
     */
    public function isPermanent()
    {
        return FreeTrialSystemNotifications::isFreeTrialExpired();
    }
}
