<?php

/*
 * This file is part of the Active Collab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

/**
 * Uploaded files table definition.
 *
 * @package angie.frameworks.environment
 * @subpackage resources
 */

return DB::createTable('uploaded_files')->addColumns([
    DBIdColumn::create(),
    DBTypeColumn::create('LocalUploadedFile'),
    DBFileMetaColumn::create(),
    DBStringColumn::create('code', 50),
    DBCreatedOnByColumn::create(true),
    DBIpAddressColumn::create('ip_address'),
    DBAdditionalPropertiesColumn::create(),
])->addIndices([
    DBIndex::create('code', DBIndex::UNIQUE),
]);
