<?php

/*
 * This file is part of the Active Collab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

namespace Angie\Authentication\RequestProcessor;

use ActiveCollab\Authentication\Authorizer\RequestProcessor\RequestProcessingResult\RequestProcessingResult;
use ActiveCollab\Authentication\Authorizer\RequestProcessor\RequestProcessorInterface;
use ActiveCollab\Authentication\Saml\SamlUtils;
use Angie\Http\Response\MovedResource\MovedResource;
use Psr\Http\Message\ServerRequestInterface;

/**
 * @package Angie\Authentication\RequestProcessor
 */
class SamlRequestProcessor implements RequestProcessorInterface
{
    /**
     * @var SamlUtils
     */
    private $saml_utils;

    /**
     * UserSessionController constructor.
     */
    public function __construct()
    {
        $this->saml_utils = new SamlUtils();
    }

    /**
     * {@inheritdoc}
     */
    public function processRequest(ServerRequestInterface $request)
    {
        $response = $this->saml_utils->parseSamlResponse($request->getParsedBody());

        if (empty($response)) {
            $response = [];
        }

        $credentials = ['username' => $this->saml_utils->getEmailAddress($response)];

        $redirect_url = $this->saml_utils->getIssuerUrl($response);
        $redirect_url .= strpos($redirect_url, '?') === false ? '/?prevent_redirect=1' : '&prevent_redirect=1';

        return new RequestProcessingResult($credentials, new MovedResource($redirect_url, false));
    }
}
