<?php

/*
 * This file is part of the Active Collab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

namespace Angie\TestCase;

use Angie\Events;
use Angie\Search;
use AngieApplication;
use AngieApplicationModel;
use DataObjectPool;
use DateTimeValue;

/**
 * Test case that properly initializes model.
 *
 * @package Angie\TestCase
 */
abstract class ModelTestCase extends BaseTestCase
{
    /**
     * @var array
     */
    protected $mailing_log;

    /**
     * Drop and initialize model before each test.
     */
    public function setUp()
    {
        parent::setUp();

        AngieApplicationModel::revert('test');

        Search::reset();

        AngieApplication::cache()->clear();
        empty_dir(CACHE_PATH, true);

        DataObjectPool::clear();

        Events::trigger('on_reset_manager_states');
    }

    /**
     * Tear down.
     */
    public function tearDown()
    {
        if (DateTimeValue::isCurrentTimestampLocked()) {
            DateTimeValue::unlockCurrentTimestamp();
        }

        parent::tearDown();
    }
}
