<?php

/*
 * This file is part of the Active Collab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

/**
 * Remote invoices.
 *
 * @package ActiveCollab.migrations
 */
class MigrateRemoteInvoicesTable extends AngieModelMigration
{
    /**
     *  Remote invoices.
     */
    public function up()
    {
        $this->createTable('remote_invoices', [
            DBIdColumn::create(),
            DBStringColumn::create('invoice_number', 45),
            DBStringColumn::create('client', 75),
            DBIntegerColumn::create('remote_id'),
            DBMoneyColumn::create('amount', 0),
            DBMoneyColumn::create('balance', 0),
            DBUpdatedOnByColumn::create(),
        ]);
    }
}
