<?php

/*
 * This file is part of the Active Collab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

/**
 * @package ActiveCollab.migrations
 */
class MigrateFixDeEsFrLanguages extends AngieModelMigration
{
    /**
     * {@inheritdoc}
     */
    public function up()
    {
        $languages = $this->useTables('languages')[0];

        if ($this->executeFirstCell("SELECT COUNT(id) AS 'row_count' FROM $languages") == 1) {
            $localization_file = dirname(dirname(__DIR__)) . '/localization/config.json';

            if (is_file($localization_file)) {
                $localization_config = json_decode(file_get_contents($localization_file), true);

                if (is_array($localization_config)) {
                    foreach ($localization_config as $locale => $language_settings) {
                        if (empty($language_settings['is_stable'])) {
                            continue;
                        }

                        $is_rtl = !empty($language_settings['is_rtl']);
                        $is_community_translation = !empty($language_settings['is_community_translation']);

                        $this->execute("INSERT INTO $languages (name, locale, decimal_separator, thousands_separator, is_rtl, is_community_translation) VALUES (?, ?, ?, ?, ?, ?)", $language_settings['name_localized'], $locale, $language_settings['decimal_separator'], $language_settings['thousands_separator'], $is_rtl, $is_community_translation);
                    }
                }
            }

            $this->execute("UPDATE $languages SET updated_on = UTC_TIMESTAMP()");
        }

        $this->doneUsingTables();
    }
}
