<?php

/*
 * This file is part of the Active Collab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

/**
 * Stored files table.
 *
 * @package angie.frameworks.attachments
 * @subpackage resources
 */

return DB::createTable('files')->addColumns([
    DBIdColumn::create(),
    DBTypeColumn::create('File'),
    DBIntegerColumn::create('project_id', DBColumn::NORMAL, 0)->setUnsigned(true),
    DBFileMetaColumn::create(),
    DBBoolColumn::create('is_hidden_from_clients'),
    DBTrashColumn::create(true),
    DBCreatedOnByColumn::create(true, true),
    DBUpdatedOnByColumn::create(true, true),
    DBAdditionalPropertiesColumn::create(),
    DBTextColumn::create('search_content')->setSize(DBTextColumn::BIG),
])->addIndices([
    DBIndex::create('project_id'),
    DBIndex::create('name'),
]);
