<?php

/*
 * This file is part of the Active Collab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

use Angie\Search;

/**
 * on_search_rebuild_index event handler.
 *
 * @package activeCollab.modules.invoicing
 * @subpackage handlers
 */

/**
 * @param Angie\NamedList $actions
 */
function invoicing_handle_on_search_rebuild_index(Angie\NamedList &$actions)
{
    $actions->add('rebuild_invoices', [
        'label' => lang('Rebuild invoices search index'),
        'callback' => function () {
            if ($invoices = Invoices::find(['order' => 'id'])) {
                Search::getAdapter()->batchStart('Invoice');

                foreach ($invoices as $invoice) {
                    Search::getAdapter()->batchAdd($invoice);
                }

                Search::getAdapter()->batchDone('Invoice');
            }
        },
    ]);

    $actions->add('rebuild_estimates', [
        'label' => lang('Rebuild estimates search index'),
        'callback' => function () {
            if ($estimates = Estimates::find(['order' => 'id'])) {
                Search::getAdapter()->batchStart('Estimate');

                foreach ($estimates as $estimate) {
                    Search::getAdapter()->batchAdd($estimate);
                }

                Search::getAdapter()->batchDone('Estimate');
            }
        },
    ]);
}
