<?php

/*
 * This file is part of the Active Collab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

use Angie\Http\Request;
use Angie\Http\Response;

AngieApplication::useController('integration_singletons', SystemModule::NAME);

/**
 * @package activeCollab.modules.system
 * @subpackage controllers
 */
class ZapierIntegrationController extends IntegrationSingletonsController
{
    /** @var ZapierIntegration $integration */
    protected $integration;

    /**
     * {@inheritdoc}
     */
    protected function __before(Request $request, $user)
    {
        $before_result = parent::__before($request, $user);

        if ($before_result !== null) {
            return $before_result;
        }

        $this->integration = Integrations::findFirstByType('ZapierIntegration');

        if (!($this->integration instanceof ZapierIntegration)) {
            return Response::CONFLICT;
        }
    }

    /**
     * Return account url and token.
     *
     * @param  User      $user
     * @return array|int
     */
    public function get_data(Request $request, User $user)
    {
        if ($this->integration->isInUse($user)) {
            return $this->integration->getDataForUser($user);
        }

        return Response::FORBIDDEN;
    }

    /**
     * Enable integrations.
     *
     * @param  Request               $request
     * @param  User                  $user
     * @return ZapierIntegration|int
     */
    public function enable(Request $request, User $user)
    {
        if ($user) {
            return $this->integration->enable($user);
        }

        return Response::FORBIDDEN;
    }

    /**
     * Disable integration.
     *
     * @param  Request $request
     * @param  User    $user
     * @return int
     */
    public function disable(Request $request, User $user)
    {
        if ($user) {
            return $this->integration->disable($user);
        }

        return Response::FORBIDDEN;
    }
}
