<?php

/*
 * This file is part of the Active Collab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

use Angie\Search;

/**
 * on_search_set_up_types event handler.
 *
 * @package ActiveCollab.modules.system
 * @subpackage handlers
 */

/**
 * Handle on_search_set_up_types event.
 */
function system_handle_on_search_set_up_types()
{
    Search::getAdapter()->initializeType([
        'User' => (new Owner())->getSearchFields(),
        'Company' => (new Company())->getSearchFields(),
        'Project' => (new Project())->getSearchFields(),
        'Discussion' => (new Discussion())->getSearchFields(),
        'File' => (new LocalFile())->getSearchFields(),
        'TaskList' => (new TaskList())->getSearchFields(),
        'Task' => (new Task())->getSearchFields(),
        'Note' => (new Note())->getSearchFields(),
    ]);
}
