<?php

/*
 * This file is part of the Active Collab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

/**
 * Project template discussion.
 *
 * @package ActiveCollab.modules.system
 * @subpackage models
 */
class ProjectTemplateDiscussion extends ProjectTemplateElement implements IBody
{
    use IBodyImplementation;

    /**
     * Return array of element properties.
     *
     * Key is name of the property, and value is a casting method
     *
     * @return array
     */
    public function getElementProperties()
    {
        return ['is_hidden_from_clients' => 'boolval'];
    }

    /**
     * Return required element properties.
     *
     * @return array
     */
    public function getRequiredElementProperties()
    {
        return ['name'];
    }
}
