<?php

/*
 * This file is part of the Active Collab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

use ActiveCollab\Authentication\Authorizer\SamlAuthorizer;
use Angie\Authentication\Repositories\UsersRepository;
use Angie\Authentication\RequestProcessor\SamlRequestProcessor;

/**
 * @package ActiveCollab.modules.system
 * @subpackage models
 */
abstract class IdpAuthorizationIntegration extends AuthorizationIntegration
{
    /**
     * {@inheritdoc}
     */
    public function getAuthorizer()
    {
        return new SamlAuthorizer(new UsersRepository(), new SamlRequestProcessor());
    }

    /**
     * @return string
     */
    public function getConsumerServiceUrl()
    {
        return ROOT_URL . '/api/v1/user-session';
    }

    /**
     * @return string
     */
    public function getIssuer()
    {
        $url = isset($_SERVER['HTTP_REFERER']) ? $_SERVER['HTTP_REFERER'] : '';

        return str_starts_with($url, ROOT_URL, false) ? $url : ROOT_URL;
    }
}
