<?php

/*
 * This file is part of the Active Collab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

/**
 * Application level labels manager.
 *
 * @package ActiveCollab.modules.system
 * @subpackage models
 */
class Labels extends FwLabels
{
    /**
     * Return new collection.
     *
     * @param  string            $collection_name
     * @param  User|null         $user
     * @return ModelCollection
     * @throws InvalidParamError
     */
    public static function prepareCollection($collection_name, $user)
    {
        $collection = parent::prepareCollection($collection_name, $user);

        switch ($collection_name) {
            case 'project_labels':
                $collection->setConditions(['type = ?', 'ProjectLabel']);
                break;
            case 'task_labels':
                $collection->setConditions(['type = ?', 'TaskLabel']);
                break;
            case DataManager::ALL:
                break;
            default:
                throw new InvalidParamError('collection_name', $collection_name);
        }

        return $collection;
    }

    /**
     * Return array of project ID-s in which this label is used.
     *
     * @param  Project $project
     * @return array
     */
    public static function getLabelIdsByProject(Project $project)
    {
        $label_ids = DB::executeFirstColumn('SELECT DISTINCT pl.label_id FROM parents_labels AS pl LEFT JOIN tasks AS t ON pl.parent_type = ? AND pl.parent_id = t.id WHERE t.project_id = ?', 'Task', $project->getId());

        if (empty($label_ids)) {
            $label_ids = [];
        }

        return $label_ids;
    }
}
