<?php

/*
 * This file is part of the Active Collab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

/**
 * Application level failed login notification.
 *
 * @package ActiveCollab.modules.system
 * @subpackage notifications
 */
class FailedLoginNotification extends Notification
{
    /**
     * Return max attempts.
     *
     * @return string
     */
    public function getMaxAttempts()
    {
        return $this->getAdditionalProperty('max_attempts');
    }

    /**
     * Set max attempts.
     *
     * @param  string $value
     * @return $this
     */
    public function &setMaxAttempts($value)
    {
        $this->setAdditionalProperty('max_attempts', $value);

        return $this;
    }

    /**
     * Return from IP address.
     *
     * @return string
     */
    public function getFromIP()
    {
        return $this->getAdditionalProperty('from_ip');
    }

    /**
     * Set from IP address.
     *
     * @param  string $value
     * @return $this
     */
    public function &setFromIP($value)
    {
        $this->setAdditionalProperty('from_ip', $value);

        return $this;
    }

    /**
     * Return additional template variables.
     *
     * @param  NotificationChannel $channel
     * @return array
     */
    public function getAdditionalTemplateVars(NotificationChannel $channel)
    {
        return [
            'max_attempts' => $this->getMaxAttempts(),
            'from_ip' => $this->getFromIP(),
        ];
    }

    /**
     * This notification should not be displayed in web interface.
     *
     * @param  NotificationChannel $channel
     * @param  IUser               $recipient
     * @return bool
     */
    public function isThisNotificationVisibleInChannel(NotificationChannel $channel, IUser $recipient)
    {
        if ($channel instanceof EmailNotificationChannel) {
            return true; // Force email, regardless of settings
        }

        return parent::isThisNotificationVisibleInChannel($channel, $recipient);
    }
}
