<?php

/*
 * This file is part of the Active Collab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

const FEATURE_VISIBILITY_OWNER = 'owner';
const FEATURE_VISIBILITY_MEMBER = 'member';
const FEATURE_VISIBILITY_FINANCIAL = 'financial';
const FEATURE_VISIBILITY_MANAGER = 'manager';
const FEATURE_VISIBILITY_CLIENT = 'client';

return [
    [
        'title' => lang('More Languages'),
        'description' => lang('Use Active Collab in Russian or Swedish (in addition to Dutch, English, French, German, Polish, and Spanish).'),
        'date' => '2016-10-04',
        'action_title' => lang('Change Language'),
        'action_url' => 'profile',
        'visibility' => FEATURE_VISIBILITY_CLIENT,
    ], [
        'title' => lang('Email Notification Settings'),
        'description' => lang('Control how much email you want to receive from Active Collab.'),
        'date' => '2016-09-07',
        'action_title' => lang('Go to Preferences'),
        'action_url' => 'settings',
        'visibility' => FEATURE_VISIBILITY_CLIENT,
    ], [
        'title' => lang('Google Drive Integration'),
        'description' => lang('Share your Google Drive documents as attachments in Active Collab.'),
        'date' => '2016-09-07',
        'action_title' => lang('Go to the Add-On'),
        'action_url' => 'integrations/google-drive',
        'visibility' => FEATURE_VISIBILITY_OWNER,
    ], [
        'title' => lang('Dropbox Integration'),
        'description' => lang('Share Dropbox files on projects with your team.'),
        'date' => '2016-09-07',
        'action_title' => lang('Go to the Add-On'),
        'action_url' => 'integrations/dropbox',
        'visibility' => FEATURE_VISIBILITY_OWNER,
    ], [
        'title' => lang('Advanced Mode for Time Report'),
        'description' => lang('Advanced time search and filtering.'),
        'date' => '2016-08-16',
        'action_title' => lang('Go to the Report'),
        'action_url' => 'reports/time-tracking',
        'visibility' => FEATURE_VISIBILITY_MANAGER,
    ], [
        'title' => lang('Projects Report'),
        'description' => lang('List all the projects that meet certain criteria.'),
        'date' => '2016-08-16',
        'action_title' => lang('Go to the Report'),
        'action_url' => 'reports/projects',
        'visibility' => FEATURE_VISIBILITY_MANAGER,
    ], [
        'title' => lang('Invoices Report'),
        'description' => lang('Find all the invoices you need that meet certain criteria.'),
        'date' => '2016-08-16',
        'action_title' => lang('Go to the Report'),
        'action_url' => 'reports/invoices',
        'visibility' => FEATURE_VISIBILITY_FINANCIAL,
    ], [
        'title' => lang('Xero Integration'),
        'description' => lang('Create invoices from billable time and expenses in Active Collab, and then send them to your Xero account for further processing.'),
        'date' => '2016-08-16',
        'action_title' => lang('Go to the Add-On'),
        'action_url' => 'integrations/xero',
        'visibility' => FEATURE_VISIBILITY_OWNER,
    ], [
        'title' => lang('iCalendar Projects Feed'),
        'description' => lang('Import project task and task list dates into your favorite calendar app so you can see what is coming up.'),
        'date' => '2016-08-07',
        'action_title' => lang('Learn More'),
        'action_url' => 'https://help.activecollab.com/books/activity/calendar.html#s-exporting-calendar-feeds',
        'visibility' => FEATURE_VISIBILITY_MEMBER,
    ], [
        'title' => lang('Hubstaff Integration'),
        'description' => lang('Track time on Active Collab tasks using the Hubstaff timer and keep time logs synced across both systems.'),
        'date' => '2016-07-04',
        'action_title' => lang('Go to the Add-On'),
        'action_url' => 'integrations/hubstaff',
        'visibility' => FEATURE_VISIBILITY_OWNER,
    ], [
        'title' => lang('Team Timeline'),
        'description' => lang('See how much work each team member has on a Gantt-like timeline so you can plan and manage their workload better.'),
        'date' => '2016-07-04',
        'action_title' => lang('Go to the Report'),
        'action_url' => 'reports/team-timeline',
        'visibility' => FEATURE_VISIBILITY_MANAGER,
    ], [
        'title' => lang('Projects Timeline'),
        'description' => lang('See all your projects on a Gantt-like timeline so you can plan and manage them better.'),
        'date' => '2016-07-04',
        'action_title' => lang('Go to the Report'),
        'action_url' => 'reports/projects-timeline',
        'visibility' => FEATURE_VISIBILITY_MANAGER,
    ], [
        'title' => lang('More Languages'),
        'description' => lang('Use Active Collab in Dutch, Italian, and Polish (in addition to English, French, German, and Spanish).'),
        'date' => '2016-07-04',
        'action_title' => lang('Change Language on the Profile Page'),
        'action_url' => 'profile',
        'visibility' => FEATURE_VISIBILITY_CLIENT,
    ], [
        'title' => lang('Recurring Tasks'),
        'description' => lang('Save time by letting Active Collab automatically create recurring tasks every day, week, or month.'),
        'date' => '2016-05-19',
        'action_title' => lang('Learn More'),
        'action_url' => 'https://blog.activecollab.com/product/2016/05/19/recurring-tasks.html',
        'visibility' => FEATURE_VISIBILITY_MEMBER,
    ], [
        'title' => lang('Exact Time and Date on Comments'),
        'description' => lang('Hover the mouse over when a comment was posted, and the exact time and date will appear in a few seconds.'),
        'date' => '2016-05-19',
        'action_title' => lang('Go to Projects'),
        'action_url' => 'projects',
        'visibility' => FEATURE_VISIBILITY_CLIENT,
    ], [
        'title' => lang('Quick Jump'),
        'description' => lang('Instantly open any part of Active Collab or project by pressing CMD+K (Mac) or CTRL+K (Windows).'),
        'date' => '2016-05-19',
        'action_title' => lang('Learn Other Shortcuts'),
        'action_url' => 'https://help.activecollab.com/books/my-active-collab/keyboard-shortcuts.html',
        'visibility' => FEATURE_VISIBILITY_CLIENT,
    ], [
        'title' => lang('Client+'),
        'description' => lang('Give clients a Client+ role so they can create and assign tasks as well as be an assignee.'),
        'date' => '2016-03-30',
        'action_title' => lang('Go to the Add-On'),
        'action_url' => 'integrations/client-plus',
        'visibility' => FEATURE_VISIBILITY_OWNER,
    ], [
        'title' => lang('Slack Integration'),
        'description' => lang('Connect Active Collab projects to a Slack channel to receive notifications whenever something happens on your projects.'),
        'date' => '2016-03-30',
        'action_title' => lang('Go to the Integration'),
        'action_url' => 'integrations/slack',
        'visibility' => FEATURE_VISIBILITY_OWNER,
    ], [
        'title' => lang('Custom Date Ranges in Time Report'),
        'description' => lang('Pick a custom date range in the Time, Expense, or Payments report.'),
        'date' => '2016-03-30',
        'action_title' => lang('Go to the Reports'),
        'action_url' => 'reports',
        'visibility' => FEATURE_VISIBILITY_MANAGER,
    ], [
        'title' => lang('QuickBooks Integration'),
        'description' => lang('Create invoices from billable time and expenses in Active Collab, and then send them to your QuickBooks account for further processing.'),
        'date' => '2016-02-03',
        'action_title' => lang('Go to the Integration'),
        'action_url' => 'integrations/quickbooks',
        'visibility' => FEATURE_VISIBILITY_OWNER,
    ], [
        'title' => lang('Languages'),
        'description' => lang('Use Active Collab in English, French, German, or Spanish.'),
        'date' => '2016-02-03',
        'action_title' => lang('Change Language on the Profile Page'),
        'action_url' => 'profile',
        'visibility' => FEATURE_VISIBILITY_CLIENT,
    ], [
        'title' => lang('Trello Importer'),
        'description' => lang('Copy your Trello projects into Active Collab.'),
        'date' => '2016-02-03',
        'action_title' => lang('Go to the Integration'),
        'action_url' => 'integrations/trello-importer',
        'visibility' => FEATURE_VISIBILITY_OWNER,
    ], [
        'title' => lang('Basecamp Importer'),
        'description' => lang('Copy your Basecamp projects into Active Collab.'),
        'date' => '2015-11-13',
        'action_title' => lang('Go to the Integration'),
        'action_url' => 'integrations/basecamp-importer',
        'visibility' => FEATURE_VISIBILITY_OWNER,
    ], [
        'title' => lang('Webhooks'),
        'description' => lang('Notify 3rd party services about what’s happening in Active Collab. Webhooks lets you integrate with existing apps for custom workflows.'),
        'date' => '2015-11-13',
        'action_title' => lang('Go to the Integration'),
        'action_url' => 'integrations/webhooks',
        'visibility' => FEATURE_VISIBILITY_OWNER,
    ], [
        'title' => lang('Mail to Project'),
        'description' => lang('Create tasks and post comments directly from your email. When you get an email notification, just send a reply to post a comment. Send emails to a project email address to create tasks.'),
        'date' => '2015-11-13',
        'action_title' => lang('See How It Works'),
        'action_url' => 'https://help.activecollab.com/books/projects/email-to-projects.html',
        'visibility' => FEATURE_VISIBILITY_CLIENT,
    ], [
        'title' => lang('Timeline View'),
        'description' => lang('Manage and schedule all your tasks in a Gantt-like timeline.'),
        'date' => '2015-11-13',
        'action_title' => lang('See How It Works'),
        'action_url' => 'https://help.activecollab.com/books/projects/tasks.html#s-using-task-views',
        'visibility' => FEATURE_VISIBILITY_CLIENT,
    ], [
        'title' => lang('Column View'),
        'description' => lang('See your tasks as cards on a Kanban board and move them across columns.'),
        'date' => '2015-11-13',
        'action_title' => lang('See How It Works'),
        'action_url' => 'https://help.activecollab.com/books/projects/tasks.html#s-using-task-views',
        'visibility' => FEATURE_VISIBILITY_CLIENT,
    ],
];
