<?php

/*
 * This file is part of the Active Collab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

/**
 * User table definition.
 *
 * @package angie.frameworks.authentication
 * @subpackage resources
 */

return DB::createTable('users')->addColumns([
    DBIdColumn::create(),
    DBTypeColumn::create('User'),
    DBFkColumn::create('company_id', 0, true),
    DBFkColumn::create('language_id'),
    DBStringColumn::create('first_name', 50),
    DBStringColumn::create('last_name', 50),
    DBStringColumn::create('title'),
    DBStringColumn::create('email', 150, ''),
    DBStringColumn::create('phone'),
    DBStringColumn::create('im_type'),
    DBStringColumn::create('im_handle'),
    DBStringColumn::create('password', DBStringColumn::MAX_LENGTH, ''),
    DBEnumColumn::create('password_hashed_with', ['php', 'pbkdf2'], 'php'),
    DBStringColumn::create('password_reset_key', 20),
    DBDateTimeColumn::create('password_reset_on'),
    DBStringColumn::create('avatar_location', DBStringColumn::MAX_LENGTH),
    DBCreatedOnByColumn::create(),
    DBUpdatedOnColumn::create(),
    DBArchiveColumn::create(true),
    DBTrashColumn::create(true),
    DBAdditionalPropertiesColumn::create(),
])->addIndices([
    DBIndex::create('email'),
]);
