<?php

/*
 * This file is part of the Active Collab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

use Angie\Search\Filter;

/**
 * on_user_search_filter event handler.
 *
 * @package ActiveCollab.modules.tasks
 * @subpackage handlers
 */

/**
 * @param User   $user
 * @param Filter $filter
 */
function tasks_handle_on_user_access_search_filter(User $user, Filter &$filter)
{
    $project_ids = $user->getProjectIds();

    if ($project_ids && is_foreachable($project_ids)) {
        $properties_filter = ['project_id' => $project_ids];

        if ($user instanceof Client) {
            $properties_filter['is_hidden_from_clients'] = false;
        }

        $filter->byTypeAndProperties('TaskList', $properties_filter);
        $filter->byTypeAndProperties('Task', $properties_filter);
    }
}
