<?php

/*
 * This file is part of the Active Collab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

namespace ActiveCollab\Module\Tracking\Metric;

use Angie\Metric\Pie;
use DateValue;
use DB;
use ITrackingObject;

/**
 * @package ActiveCollab\Module\Tracking\Metric
 */
class TimeRecordsByBillableStatus extends Pie
{
    /**
     * {@inheritdoc}
     */
    public function getValueFor(DateValue $date)
    {
        $not_billable = 0;
        $billable = 0;
        $invoiced = DB::executeFirstCell('SELECT COUNT(id) AS "row_count" FROM time_records WHERE invoice_item_id > ?', 0);

        if ($rows = DB::execute('SELECT COUNT(id) AS "row_count", billable_status FROM time_records WHERE is_trashed = ? GROUP BY billable_status', false)) {
            foreach ($rows as $row) {
                if ($row['billable_status'] == ITrackingObject::NOT_BILLABLE) {
                    $not_billable += $row['row_count'];
                } else {
                    $billable += $row['row_count'];
                }
            }
        }

        return $this->produceResult([
            'not_billable' => $not_billable,
            'billable' => $billable,
            'invoiced' => $invoiced,
        ], $date);
    }
}
