<?php

/*
 * This file is part of the Active Collab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

namespace ActiveCollab\ActiveCollabJobs\Jobs\Instance;

use InvalidArgumentException;

/**
 * @package ActiveCollab\ActiveCollabJobs\Jobs\Instance
 */
class UploadProjectTemplateFileToWarehouse extends UploadToWarehouse
{
    /**
     * Construct a new Job instance.
     *
     * @param  array|null               $data
     * @throws InvalidArgumentException
     */
    public function __construct(array $data = null)
    {
        if (empty($data['project_template_file_id'])) {
            throw new InvalidArgumentException("'project_template_file_id' property is required");
        }

        $data['action'] = 'project_template_file';

        return parent::__construct($data);
    }
}
