<?php

/*
 * This file is part of the Active Collab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

namespace ActiveCollab\ActiveCollabJobs\Jobs\Shepherd;

use InvalidArgumentException;

/**
 * @package ActiveCollab\ActiveCollabJobs\Jobs\Instance
 */
class UpdateInstanceSettings extends ExecuteShephedCliCommand
{
    /**
     * {@inheritdoc}
     */
    public function __construct(array $data = null)
    {
        $instance_id = !empty($data['instance_id']) ? (int) $data['instance_id'] : 0;

        if ($instance_id < 1) {
            throw new InvalidArgumentException('Valid instance_id is required');
        }

        $command_options = ['instance' => $instance_id];

        if (!empty($data['settings'])) {
            $command_options['settings'] = serialize($data['settings']);
        }

        parent::__construct(array_merge($data, [
            'command' => 'instance_settings',
            'command_arguments' => [],
            'command_options' => $command_options,
        ]));
    }
}
