<?php

/*
 * This file is part of the Active Collab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

namespace ActiveCollab\ActiveCollabJobs\Jobs\Shepherd;

use InvalidArgumentException;

/**
 * @package ActiveCollab\ActiveCollabJobs\Jobs\Shepherd
 */
class UpdateUser extends ExecuteShephedCliCommand
{
    /**
     * {@inheritdoc}
     */
    public function __construct(array $data = null)
    {
        $data['instance_id'] = !empty($data['instance_id']) ? (int) $data['instance_id'] : 0;

        if ($data['instance_id'] < 1) {
            throw new InvalidArgumentException('Valid instance_id is required');
        }

        $data['user_id'] = !empty($data['user_id']) ? (int) $data['user_id'] : 0;

        if ($data['user_id'] < 1) {
            throw new InvalidArgumentException('Valid user_id is required');
        }

        parent::__construct(array_merge($data, [
            'command' => 'update_user_profile',
            'command_arguments' => [],
            'command_options' => ['instance-id' => $data['instance_id'], 'user-id' => $data['user_id']],
        ]));
    }
}
