<?php

/*
 * This file is part of the Active Collab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

namespace ActiveCollab\ActiveCollabJobs\Jobs\Warehouse;

use ActiveCollab\JobsQueue\Jobs\Job;
use ActiveCollab\Warehouse\Api\FileApi;
use ActiveCollab\Warehouse\Api\UrlCreator;
use ActiveCollab\Warehouse\Client;
use InvalidArgumentException;

/**
 * @package ActiveCollab\ActiveCollabJobs\Jobs\Warehouse
 */
class DeleteFileRequest extends Job
{
    /**
     * {@inheritdoc}
     */
    public function __construct(array $data = null)
    {
        if (empty($data['location'])) {
            throw new InvalidArgumentException('File location is required');
        }

        if (empty($data['access_token'])) {
            throw new InvalidArgumentException('Access token is required');
        }

        if (empty($data['warehouse_url'])) {
            throw new InvalidArgumentException('Warehouse URL is required');
        }

        if (empty($data['headers'])) {
            $data['headers'] = [];
        }

        if (!array_key_exists('timeout', $data)) {
            $data['timeout'] = 30;
        }

        parent::__construct($data);
    }

    /**
     * Send HTTP request.
     */
    public function execute()
    {
        $data = $this->getData();
        $file_api = new FileApi(new Client($data['access_token']), new UrlCreator($data['warehouse_url']));
        $file_api->deleteFile($data['location']);
    }
}
