<?php

/*
 * This file is part of the Active Collab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

namespace ActiveCollab\Command\User;

use Angie\Command\OnDemandCommand;
use AutoloadError;
use InvalidArgumentException;
use ReflectionClass;

/**
 * @package ActiveCollab\Command
 */
abstract class UserCommand extends OnDemandCommand
{
    /**
     * Return command name prefix.
     *
     * @return string
     */
    protected function getCommandNamePrefix()
    {
        return parent::getCommandNamePrefix() . 'user:';
    }

    /**
     * Return a valid user class from input.
     *
     * @param  string $type
     * @return string
     */
    protected function getValidUserType($type)
    {
        try {
            class_exists($type);
        } catch (AutoloadError $e) {
            throw new InvalidArgumentException("Class '$type' does not exist", 0, $e);
        }

        $type_reflection = new ReflectionClass($type);

        if (!$type_reflection->isSubclassOf('User')) {
            throw new InvalidArgumentException("Class '$type' is not a valid user class");
        }

        return $type;
    }
}
