<?php

/*
 * This file is part of the Active Collab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

/**
 * IPv6 friendly IP address column.
 *
 * @package angie.library.database
 * @subpackage engineer
 */
class DBIpAddressColumn extends DBStringColumn
{
    /**
     * Construct string column.
     *
     * @param string $name
     * @param mixed  $default
     */
    public function __construct($name, $default = null)
    {
        parent::__construct($name, $default);

        $this->length = 45;
    }

    /**
     * Create new integer column instance.
     *
     * @param  string            $name
     * @param  mixed             $default
     * @return DBIpAddressColumn
     */
    public static function create($name, $default = null)
    {
        return new self($name, $default);
    }
}
