<?php

/*
 * This file is part of the Active Collab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

/**
 * Archive column.
 *
 * @package angie.library.database
 * @subpackage engineer
 */
class DBArchiveColumn extends DBCompositeColumn
{
    /**
     * Construct trash column instance.
     *
     * Set $cascade to true in cases where model can be archived when parent object is archived
     *
     * @param bool $cascade
     */
    public function __construct($cascade = false)
    {
        $this->columns = [DBBoolColumn::create('is_archived')];

        if ($cascade) {
            $this->columns[] = DBBoolColumn::create('original_is_archived');
        }
    }

    /**
     * Construct and return user column.
     *
     * Set $cascade to true in cases where model can be archived when parent object is archived
     *
     * @param  bool          $cascade
     * @return DBTrashColumn
     */
    public static function create($cascade = false)
    {
        return new self($cascade);
    }
}
