<?php

/*
 * This file is part of the Active Collab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

/**
 * Updated on column.
 *
 * @package angie.library.database
 * @subpackage engineer
 */
class DBUpdatedOnColumn extends DBDateTimeColumn
{
    /**
     * Create new updated_on field column.
     */
    public function __construct()
    {
        parent::__construct('updated_on');
    }

    /**
     * Create new created on column instance.
     *
     * @return DBCreatedOnColumn
     */
    public static function create()
    {
        return new self();
    }

    /**
     * Trigger after this column gets added to the table.
     */
    public function addedToTable()
    {
        $this->table->addModelTrait('IUpdatedOn', 'IUpdatedOnImplementation');

        parent::addedToTable();
    }
}
