<?php

/*
 * This file is part of the Active Collab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

use Angie\Error;

/**
 * Autoload error implementation.
 *
 * @package angie.library.errors
 */
class AutoloadError extends Error
{
    /**
     * Construct autoload error instance.
     *
     * @param string $class
     * @param string $message
     */
    public function __construct($class, $message = null)
    {
        if (empty($message)) {
            $message = "Failed to load class '$class'";
        }

        parent::__construct($message, ['class' => $class]);
    }
}
