<?php

/*
 * This file is part of the Active Collab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

/**
 * Comments framework model definition.
 *
 * @package angie.frameworks.comments
 * @subpackage resources
 */
class CommentsFrameworkModel extends AngieFrameworkModel
{
    /**
     * Construct comments framework model definition.
     *
     * @param CommentsFramework $parent
     */
    public function __construct(CommentsFramework $parent)
    {
        parent::__construct($parent);

        $this->addModel(DB::createTable('comments')->addColumns([
            DBIdColumn::create(),
            DBStringColumn::create('source', 50),
            DBParentColumn::create(),
            DBBodyColumn::create(),
            DBIpAddressColumn::create('ip_address'),
            DBCreatedOnByColumn::create(true, true),
            DBUpdatedOnByColumn::create(),
            DBTrashColumn::create(true),
        ]))->setOrderBy('created_on DESC, id DESC')
            ->implementAttachments()
            ->implementHistory()
            ->implementActivityLog()
            ->implementTrash();
    }
}
