<?php

/*
 * This file is part of the Active Collab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

use Angie\Http\Request;

AngieApplication::useController('auth_required', EnvironmentFramework::INJECT_INTO);

/**
 * Make sure that frontend has all the info that is needed for bootstrapping.
 *
 * @package angie.frameworks.environment
 * @subpackage controllers
 */
abstract class FwInitialController extends AuthRequiredController
{
    /**
     * @param  Request $request
     * @param  User    $user
     * @return array
     */
    public function index(Request $request, $user)
    {
        return Users::prepareCollection('initial', $user);
    }

    /**
     * Test controller action speed.
     */
    public function test_action_speed()
    {
        return ['action_speed' => round(microtime(true) - ANGIE_SCRIPT_TIME, 5)];
    }
}
