<?php

/*
 * This file is part of the Active Collab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

abstract class BaseStorageAdapter implements StorageAdapterInterface
{
    /**
     * @var int
     */
    private $plan_max_size;

    /**
     * @var int
     */
    private $grace_percent = 0;

    /**
     * @var int
     */
    private $grace_max_bytes = 0;

    /**
     * Return true if disk usage exceeds disk storage plan max size.
     *
     * @param  bool|false $be_graceful
     * @return bool
     */
    abstract public function isDiskFull($be_graceful = false);

    /**
     * @return int
     */
    public function getPlanMaxSize()
    {
        return $this->plan_max_size;
    }

    /**
     * @param int $plan_max_size
     */
    public function setPlanMaxSize($plan_max_size)
    {
        $this->plan_max_size = $plan_max_size;
    }

    /**
     * @return int
     */
    public function getGracePercent()
    {
        return $this->grace_percent;
    }

    /**
     * @param int $grace_percent
     */
    public function setGracePercent($grace_percent)
    {
        $this->grace_percent = $grace_percent;
    }

    /**
     * @return int
     */
    public function getGraceMaxBytes()
    {
        return $this->grace_max_bytes;
    }

    /**
     * @param int $grace_max_bytes
     */
    public function setGraceMaxBytes($grace_max_bytes)
    {
        $this->grace_max_bytes = $grace_max_bytes;
    }

    /**
     * Return the sum of all file sizes used in across the system.
     *
     * @return mixed
     */
    public function getDiskUsage()
    {
        $files_size = (int) DB::executeFirstCell('SELECT SUM(size) FROM files WHERE is_trashed = ? AND type NOT IN (?)', false, [GoogleDriveFile::class, DropboxFile::class]);
        $attachments_size = (int) DB::executeFirstCell('SELECT SUM(size) FROM attachments WHERE type NOT IN (?)', [GoogleDriveAttachment::class, DropboxAttachment::class]);
        $uploaded_files_size = (int) DB::executeFirstCell('SELECT SUM(size) FROM uploaded_files WHERE type NOT IN (?)', [GoogleDriveUploadedFile::class, DropboxUploadedFile::class]);

        if (AngieApplication::isEdgeChannel()) {
            AngieApplication::log()->info('Disk usage calculation performed', [
                'file_size' => $files_size,
                'attachments_size' => $attachments_size,
                'uploaded_files_size' => $uploaded_files_size,
            ]);
        }

        return $files_size + $attachments_size + $uploaded_files_size;
    }
}
