<?php

/*
 * This file is part of the Active Collab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

class LocalFilesStorage extends BaseStorageAdapter
{
    /**
     * {@inheritdoc}
     */
    public function deleteFile($location)
    {
        $file_path = AngieApplication::fileLocationToPath($location);
        if (is_file($file_path)) {
            @unlink($file_path);
        } else {
            AngieApplication::log()->warning('Attempted to delete non existing local file with location: {location}', ['location' => $location]);
        }
    }

    /**
     * {@inheritdoc}
     */
    public function isDiskFull($be_graceful = false)
    {
        return false;
    }
}
