<?php

/*
 * This file is part of the Active Collab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

/**
 * Free Trial system notification.
 *
 * @package angie.environment
 * @subpackage models
 */
class FreeTrialSystemNotifications extends SystemNotifications
{
    /**
     * Return 'type' attribute for polymorh model creation.
     *
     * @return mixed|string
     */
    public static function getType()
    {
        return 'FreeTrialSystemNotification';
    }

    /**
     * Return true if this notification should ne raised.
     *
     * @return mixed|void
     */
    public static function shouldBeRaised()
    {
        if (AngieApplication::isOnDemand() && (ON_DEMAND_ACCOUNT_STATUS == OnDemand::STATUS_ACTIVE_FREE || self::isFreeTrialExpired())) {
            $scheduled_to_show = in_array(self::freeTrialExpiresInDays(), [15, 7, 3, 2, 1, 0]);
            if (self::isFreeTrialExpired() || $scheduled_to_show) {
                self::clearNotifications(); // remove notifications of this type and show the new ones
                return true;
            }

            return false;
        }

        return false;
    }

    /**
     * Is free trial expired.
     *
     * @return bool
     */
    public static function isFreeTrialExpired()
    {
        return defined('ON_DEMAND_ACCOUNT_STATUS') && ON_DEMAND_ACCOUNT_STATUS == 4;
    }

    /**
     * Get days to account expiration.
     *
     * @return int
     */
    public static function freeTrialExpiresInDays()
    {
        return DateValue::now()->daysBetween(self::freeTrialExpiresOn());
    }

    /**
     * Account Expires On.
     *
     * @return DateValue
     */
    public static function freeTrialExpiresOn()
    {
        return defined('ON_DEMAND_ACCOUNT_STATUS_EXPIRES_ON') && defined('ON_DEMAND_ACCOUNT_STATUS') && ON_DEMAND_ACCOUNT_STATUS == 1 ? new DateValue(ON_DEMAND_ACCOUNT_STATUS_EXPIRES_ON) : DateValue::now();
    }
}
