<?php

/*
 * This file is part of the Active Collab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

/**
 * Introduce alternative user addresses.
 *
 * @package angie.migrations
 */
class MigrateIntroduceUserAddresses extends AngieModelMigration
{
    /**
     * Migrate up.
     */
    public function up()
    {
        $this->createTable('user_addresses', [
            DBIntegerColumn::create('user_id', DBColumn::NORMAL, 0)->setUnsigned(true),
            DBStringColumn::create('email', 150, ''),
        ], [
            DBIndexPrimary::create(['user_id', 'email']),
        ]);
    } // up

    /**
     * Migrate down.
     */
    public function down()
    {
        $this->dropTable('user_addresses');
    } // down
}
