<?php

/*
 * This file is part of the Active Collab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

/**
 * Added updated_on property to currencies table.
 *
 * @package angie.migrations
 */
class MigrateUpdatedOnForCurrencies extends AngieModelMigration
{
    /**
     * Migrate up.
     */
    public function up()
    {
        $currencies = $this->useTableForAlter('currencies');
        $currencies->addColumn(DBUpdatedOnColumn::create(), 'is_default');

        $this->execute('UPDATE ' . $currencies->getName() . ' SET updated_on = UTC_TIMESTAMP()');

        $this->doneUsingTables();
    }
}
