<?php

/*
 * This file is part of the Active Collab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

namespace Angie\Search\Adapter;

use Angie\Search\Adapter;
use Angie\Search\Criterion;
use Angie\Search\Item;
use User;

/**
 * Disabled search adapter (black hole).
 *
 * @package Angie\Search\Adapter
 */
class Disabled extends Adapter
{
    /**
     * Set up the index.
     */
    public function setUp()
    {
    }

    /**
     * Destroy the index.
     */
    public function tearDown()
    {
    }

    /**
     * Initialize index for the specific type.
     *
     * @param string|array $type
     * @param array|null   $fields
     */
    public function initializeType($type, $fields = null)
    {
    }

    /**
     * Return indexed record.
     *
     * @param  Item       $item
     * @return array|null
     * @todo
     */
    public function get(Item $item)
    {
    }

    /**
     * Add an item to the index.
     *
     * @param Item $item
     * @param bool $bulk
     */
    public function add(Item $item, $bulk = false)
    {
    }

    /**
     * Update an item.
     *
     * @param Item $item
     * @param bool $bulk
     */
    public function update(Item $item, $bulk = false)
    {
    }

    /**
     * Remove an item.
     *
     * @param Item $item
     * @param bool $bulk
     */
    public function remove(Item $item, $bulk = false)
    {
    }

    /**
     * Query the index.
     *
     * @param  string      $search_for
     * @param  User        $user
     * @param  Criterion[] $criterions
     * @param  int         $page
     * @return array
     */
    public function query($search_for, User $user, $criterions = null, $page = 1)
    {
    }

    /**
     * Suggest the terms for the $search_for.
     *
     * @param  string $search_for
     * @param  User   $user
     * @return array
     * @todo
     */
    public function suggest($search_for, User $user)
    {
    }

    /**
     * Start batch import of the data.
     *
     * @param string $type
     * @param int    $items_per_iteration
     */
    public function batchStart($type, $items_per_iteration = 500)
    {
    }

    /**
     * Add record to the index.
     *
     * @param Item $item
     */
    public function batchAdd($item)
    {
    }

    /**
     * Finished with the batch import.
     */
    public function batchDone($type)
    {
    }
}
