<?php

/*
 * This file is part of the Active Collab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

namespace Angie\Search\Adapter\ElasticSearch;

use Elastica\Filter\BoolAnd;
use Elastica\Filter\BoolFilter;
use Elastica\Filter\Ids;
use Elastica\Filter\Term;
use Elastica\Filter\Terms;
use Elastica\Filter\Type;

/**
 * ElasticSearch filter.
 */
class Filter extends \Angie\Search\Filter
{
    /**
     * @var bool
     */
    private $filter;

    /**
     * Constructor.
     */
    public function __construct()
    {
        $this->filter = new BoolFilter();
    }

    /**
     * @return bool
     */
    public function getFilter()
    {
        return $this->filter;
    }

    /**
     * @param string $type
     */
    public function byType($type)
    {
        $type_filter = new Type();
        $type_filter->setType($type);

        $this->filter->addShould($type_filter);

        $this->has_rules = true;
    }

    /**
     * @param string     $type
     * @param array|null $ids
     */
    public function byTypeAndIds($type, $ids)
    {
        if ($ids && is_foreachable($ids)) {
            $ids_filter = new Ids();

            $ids_filter->setType($type);
            $ids_filter->setIds($ids);

            $this->filter->addShould($ids_filter);

            $this->has_rules = true;
        }
    }

    /**
     * @param string $type
     * @param array  $fields
     */
    public function byTypeAndProperties($type, array $fields)
    {
        $and = new BoolAnd();

        $and->addFilter(new Type($type));

        foreach ($fields as $field => $value_to_match) {
            $and->addFilter($this->prepareFieldFilter($field, $value_to_match));
        }

        $this->filter->addShould($and);

        $this->has_rules = true;

//      if (count($fields) == 1) {
//        foreach ($fields as $field => $value_to_match) {
//          $this->filter->addShould($this->prepareFieldFilter($field, $value_to_match));
//        }
//      } elseif (count($fields) > 1) {
//        $and = new BoolAnd();

//        foreach ($fields as $field => $value_to_match) {
//          $and->addFilter($this->prepareFieldFilter($field, $value_to_match));
//        }

//        $this->filter->addShould($and);
//      }

//      $this->has_rules = true;
    }

    /**
     * Prepare field filter.
     *
     * @param  string     $field
     * @param  mixed      $value_to_match
     * @return Term|Terms
     */
    private function prepareFieldFilter($field, $value_to_match)
    {
        if (is_array($value_to_match)) {
            if (count($value_to_match) > 1) {
                $field_filter = new Terms();
                $field_filter->setTerms($field, $value_to_match);
            } else {
                $field_filter = new Term();
                $field_filter->setTerm($field, $value_to_match[0]);
            }
        } else {
            $field_filter = new Term();
            $field_filter->setTerm($field, $value_to_match);
        }

        return $field_filter;
    }

    /**
     * @var bool
     */
    private $has_rules = false;

    /**
     * @return bool
     */
    public function hasRules()
    {
        return $this->has_rules;
    }
}
