<?php

/*
 * This file is part of the Active Collab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

namespace Angie\Search;

/**
 * Search criterion.
 *
 * @package Angie\Search
 */
class Criterion
{
    const IN = '=';
    const BETWEEN = 'between';

    /**
     * @var string
     */
    private $field;

    /**
     * @var mixed
     */
    private $value;

    /**
     * @var string
     */
    private $operator;

    /**
     * @param string $field
     * @param mixed  $value
     * @param string $operator
     */
    public function __construct($field, $value, $operator = self::IN)
    {
        $this->field = $field;
        $this->value = $value;
        $this->operator = $operator;
    }

    /**
     * @return string
     */
    public function getField()
    {
        return $this->field;
    }

    /**
     * @return mixed
     */
    public function getValue()
    {
        return $this->value;
    }

    /**
     * @return string
     */
    public function getOperator()
    {
        return $this->operator;
    }
}
