<?php

/*
 * This file is part of the Active Collab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

namespace Angie\Search;

/**
 * Abstract sarch adapter.
 *
 * @package Angie\Search
 */
abstract class Filter
{
    /**
     * @param string $type
     */
    abstract public function byType($type);

    /**
     * @param string     $type
     * @param array|null $ids
     */
    abstract public function byTypeAndIds($type, $ids);

    /**
     * @param string $type
     * @param array  $fields
     */
    abstract public function byTypeAndProperties($type, array $fields);

    /**
     * @return bool
     */
    abstract public function hasRules();
}
